/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.runtime.app.declaration.api.fluent.BaseElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.EnrichableElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;

class GlobalElementDeclarationTypeAdapter
extends TypeAdapter<GlobalElementDeclaration> {
    private final Gson delegate;

    GlobalElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(final JsonWriter out, final GlobalElementDeclaration value) throws IOException {
        final String kind = this.getKind(value);
        out.beginObject();
        out.name("refName").value(value.getRefName());
        value.accept(new GlobalElementDeclarationVisitor(){

            @Override
            public void visit(TopLevelParameterDeclaration declaration) {
                ElementDeclarationSerializationUtils.populateIdentifiableObject(out, value, kind);
                ElementDeclarationSerializationUtils.populateCustomizableObject(GlobalElementDeclarationTypeAdapter.this.delegate, out, value);
                ElementDeclarationSerializationUtils.populateMetadataAwareObject(GlobalElementDeclarationTypeAdapter.this.delegate, out, value);
                try {
                    out.name("value").jsonValue(GlobalElementDeclarationTypeAdapter.this.delegate.toJson((Object)((TopLevelParameterDeclaration)value).getValue(), ParameterValue.class));
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("An error occurred while serializing the declaration of element [%s] of kind [%s] from extension [%s]", declaration.getName(), kind, declaration.getDeclaringExtension()), e);
                }
            }

            @Override
            public void visit(ConfigurationElementDeclaration declaration) {
                ElementDeclarationSerializationUtils.populateParameterizedObject(GlobalElementDeclarationTypeAdapter.this.delegate, out, (ParameterizedElementDeclaration)((Object)value), kind);
                GlobalElementDeclarationTypeAdapter.this.populateConnection(out, (ConfigurationElementDeclaration)value);
            }

            @Override
            public void visit(ConstructElementDeclaration declaration) {
                ElementDeclarationSerializationUtils.populateParameterizedObject(GlobalElementDeclarationTypeAdapter.this.delegate, out, (ParameterizedElementDeclaration)((Object)value), kind);
                GlobalElementDeclarationTypeAdapter.this.populateComponents(out, (ConstructElementDeclaration)value);
            }
        });
        out.endObject();
    }

    private void populateComponents(JsonWriter out, ConstructElementDeclaration value) {
        try {
            out.name("components").jsonValue(this.delegate.toJson(value.getComponents()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("An error occurred while serializing the declaration of components for element [%s] with name [%s] from extension [%s]", value.getName(), value.getRefName(), value.getDeclaringExtension()), e);
        }
    }

    public GlobalElementDeclaration read(JsonReader in) throws IOException {
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementName = jsonObject.get("name");
            JsonElement elementKind = jsonObject.get("kind");
            JsonElement elementExtension = jsonObject.get("declaringExtension");
            if (elementKind != null && elementExtension != null && elementName != null) {
                Object declarer = this.getDeclarer(ElementDeclarer.forExtension(elementExtension.getAsString()), elementKind.getAsString(), elementName.getAsString());
                if (elementKind.getAsString().equals("GLOBAL_PARAMETER")) {
                    this.declareGlobalParameter(jsonObject, (EnrichableElementDeclarer)declarer);
                } else {
                    ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, (ParameterizedElementDeclarer)declarer);
                    if (elementKind.getAsString().equals("CONFIG")) {
                        this.declareConfiguration(jsonObject, (ConfigurationElementDeclarer)declarer);
                    } else {
                        this.declareConstruct(jsonObject, (ConstructElementDeclarer)declarer);
                    }
                }
                return (GlobalElementDeclaration)((BaseElementDeclarer)declarer).getDeclaration();
            }
        }
        return null;
    }

    private void declareGlobalParameter(JsonObject jsonObject, EnrichableElementDeclarer declarer) {
        ElementDeclarationSerializationUtils.declareEnrichableElement(this.delegate, jsonObject, declarer);
        if (jsonObject.has("refName")) {
            ((TopLevelParameterDeclarer)declarer).withRefName(jsonObject.get("refName").getAsString());
        }
        ((TopLevelParameterDeclarer)declarer).withValue((ParameterObjectValue)this.delegate.fromJson(jsonObject.get("value"), ParameterValue.class));
    }

    private void declareConstruct(JsonObject jsonObject, ConstructElementDeclarer declarer) {
        JsonArray components = jsonObject.get("components").getAsJsonArray();
        if (jsonObject.has("refName")) {
            declarer.withRefName(jsonObject.get("refName").getAsString());
        }
        components.forEach(c -> {
            ConstructElementDeclarer cfr_ignored_0 = (ConstructElementDeclarer)declarer.withComponent((ComponentElementDeclaration)this.delegate.fromJson(c, ComponentElementDeclaration.class));
        });
    }

    private void declareConfiguration(JsonObject configObject, ConfigurationElementDeclarer configDeclarer) {
        configDeclarer.withRefName(configObject.get("refName").getAsString());
        JsonElement connectionElement = configObject.get("connection");
        if (connectionElement != null && connectionElement.isJsonObject()) {
            JsonObject connectionObject = connectionElement.getAsJsonObject();
            JsonElement elementName = connectionObject.get("name");
            JsonElement elementExtension = connectionObject.get("declaringExtension");
            ConnectionElementDeclarer connectionDeclarer = ElementDeclarer.forExtension(elementExtension.getAsString()).newConnection(elementName.getAsString());
            ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, connectionObject, connectionDeclarer);
            configDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
        }
    }

    private <T extends EnrichableElementDeclarer> T getDeclarer(ElementDeclarer declarer, String kind, String name) {
        switch (kind) {
            case "CONFIG": {
                return (T)declarer.newConfiguration(name);
            }
            case "GLOBAL_PARAMETER": {
                return (T)declarer.newGlobalParameter(name);
            }
            case "CONSTRUCT": {
                return (T)declarer.newConstruct(name);
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }

    private String getKind(GlobalElementDeclaration type) {
        if (type instanceof TopLevelParameterDeclaration) {
            return "GLOBAL_PARAMETER";
        }
        if (type instanceof ConfigurationElementDeclaration) {
            return "CONFIG";
        }
        if (type instanceof ConstructElementDeclaration) {
            return "CONSTRUCT";
        }
        throw new IllegalArgumentException("Unknown kind for type: " + type.getClass().getName());
    }

    private void populateConnection(JsonWriter out, ConfigurationElementDeclaration config) {
        try {
            if (config.getConnection().isPresent()) {
                out.name("connection").beginObject();
                ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, config.getConnection().get(), "CONNECTION");
                out.endObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("An error occurred while serializing the connection provider declaration of element [%s] of kind [%s] from extension [%s]", config.getName(), "config", config.getDeclaringExtension()), e);
        }
    }
}

