/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.SupportsPropertiesMuleContextBuilder;

public class ApplicationMuleContextBuilder
extends SupportsPropertiesMuleContextBuilder {
    private final String appName;
    private final String defaultEncoding;

    public ApplicationMuleContextBuilder(String appName, Map<String, String> appProperties, String defaultEncoding) {
        super(ArtifactType.APP, appProperties);
        this.appName = appName;
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        this.initializeFromProperties(configuration);
        configuration.setId(this.appName);
        String encoding = this.defaultEncoding;
        if (!StringUtils.isBlank(encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        if (this.executionClassLoader instanceof MuleApplicationClassLoader) {
            configuration.setMinMuleVersion(((ArtifactDescriptor)((MuleApplicationClassLoader)this.executionClassLoader).getArtifactDescriptor()).getMinMuleVersion());
        }
        return configuration;
    }
}

