/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyInstance;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateFactory;
import org.mule.runtime.policy.api.AttributeAwarePointcut;
import org.mule.runtime.policy.api.PolicyAwareAttributes;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public class MuleApplicationPolicyProvider
implements ApplicationPolicyProvider,
PolicyProvider,
Disposable {
    private final PolicyTemplateFactory policyTemplateFactory;
    private final PolicyInstanceProviderFactory policyInstanceProviderFactory;
    private final List<RegisteredPolicyTemplate> registeredPolicyTemplates = new LinkedList<RegisteredPolicyTemplate>();
    private final List<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProviders = new LinkedList<RegisteredPolicyInstanceProvider>();
    private PolicyAwareAttributes sourcePolicyAwareAttributes = SourcePolicyAwareAttributes.noAttributes();
    private Application application;
    private Runnable policiesChangedCallback = () -> {};

    public MuleApplicationPolicyProvider(PolicyTemplateFactory policyTemplateFactory, PolicyInstanceProviderFactory policyInstanceProviderFactory) {
        this.policyTemplateFactory = policyTemplateFactory;
        this.policyInstanceProviderFactory = policyInstanceProviderFactory;
    }

    @Override
    public synchronized void addPolicy(PolicyTemplateDescriptor policyTemplateDescriptor, PolicyParametrization parametrization) throws PolicyRegistrationException {
        try {
            Preconditions.checkArgument(this.application != null, "application was not configured on the policy provider");
            Optional<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProvider = this.registeredPolicyInstanceProviders.stream().filter(p -> p.getPolicyId().equals(parametrization.getId())).findFirst();
            if (registeredPolicyInstanceProvider.isPresent()) {
                throw new IllegalArgumentException(MuleApplicationPolicyProvider.createPolicyAlreadyRegisteredError(parametrization.getId()));
            }
            Optional<RegisteredPolicyTemplate> registeredPolicyTemplate = this.registeredPolicyTemplates.stream().filter(p -> ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getGroupId().equals(policyTemplateDescriptor.getBundleDescriptor().getGroupId()) && ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getArtifactId().equals(policyTemplateDescriptor.getBundleDescriptor().getArtifactId()) && ((PolicyTemplateDescriptor)((RegisteredPolicyTemplate)p).policyTemplate.getDescriptor()).getBundleDescriptor().getVersion().equals(policyTemplateDescriptor.getBundleDescriptor().getVersion())).findAny();
            if (!registeredPolicyTemplate.isPresent()) {
                PolicyTemplate policyTemplate = this.policyTemplateFactory.createArtifact(this.application, policyTemplateDescriptor);
                registeredPolicyTemplate = Optional.of(new RegisteredPolicyTemplate(policyTemplate));
                this.registeredPolicyTemplates.add(registeredPolicyTemplate.get());
            }
            ApplicationPolicyInstance applicationPolicyInstance = this.policyInstanceProviderFactory.create(this.application, registeredPolicyTemplate.get().policyTemplate, parametrization);
            applicationPolicyInstance.initialise();
            this.registeredPolicyInstanceProviders.add(new RegisteredPolicyInstanceProvider(applicationPolicyInstance, parametrization.getId()));
            this.registeredPolicyInstanceProviders.sort(null);
            registeredPolicyTemplate.get().count++;
            this.policiesChangedCallback.run();
        }
        catch (Exception e) {
            throw new PolicyRegistrationException(MuleApplicationPolicyProvider.createPolicyRegistrationError(parametrization.getId()), e);
        }
    }

    @Override
    public synchronized boolean removePolicy(String parametrizedPolicyId) {
        Optional<RegisteredPolicyInstanceProvider> registeredPolicyInstanceProvider = this.registeredPolicyInstanceProviders.stream().filter(p -> p.getPolicyId().equals(parametrizedPolicyId)).findFirst();
        registeredPolicyInstanceProvider.ifPresent(provider -> {
            this.registeredPolicyInstanceProviders.remove(provider);
            this.policiesChangedCallback.run();
            provider.getApplicationPolicyInstance().dispose();
            Optional<RegisteredPolicyTemplate> registeredPolicyTemplate = this.registeredPolicyTemplates.stream().filter(p -> ((RegisteredPolicyTemplate)p).policyTemplate.equals(provider.getApplicationPolicyInstance().getPolicyTemplate())).findFirst();
            if (!registeredPolicyTemplate.isPresent()) {
                throw new IllegalStateException("Cannot find registered policy template");
            }
            registeredPolicyTemplate.get().count--;
            if (registeredPolicyTemplate.get().count == 0) {
                this.application.getRegionClassLoader().removeClassLoader(registeredPolicyTemplate.get().policyTemplate.getArtifactClassLoader());
                registeredPolicyTemplate.get().policyTemplate.dispose();
                this.registeredPolicyTemplates.remove(registeredPolicyTemplate.get());
            }
        });
        return registeredPolicyInstanceProvider.isPresent();
    }

    @Override
    public synchronized boolean isPoliciesAvailable() {
        return !this.registeredPolicyInstanceProviders.isEmpty();
    }

    @Override
    public boolean isSourcePoliciesAvailable() {
        return this.registeredPolicyInstanceProviders.stream().anyMatch(pip -> pip.getApplicationPolicyInstance().getSourcePolicy().isPresent());
    }

    @Override
    public boolean isOperationPoliciesAvailable() {
        return this.registeredPolicyInstanceProviders.stream().anyMatch(pip -> pip.getApplicationPolicyInstance().getOperationPolicy().isPresent());
    }

    @Override
    public void onPoliciesChanged(Runnable policiesChangedCallback) {
        this.policiesChangedCallback = () -> {
            policiesChangedCallback.run();
            this.updatePolicyAwareAttributes();
        };
    }

    private synchronized void updatePolicyAwareAttributes() {
        this.sourcePolicyAwareAttributes = this.registeredPolicyInstanceProviders.stream().filter(pip -> pip.getApplicationPolicyInstance().getPointcut() instanceof AttributeAwarePointcut).map(pip -> ((AttributeAwarePointcut)pip.getApplicationPolicyInstance().getPointcut()).sourcePolicyAwareAttributes()).reduce(SourcePolicyAwareAttributes.noAttributes(), PolicyAwareAttributes::merge);
    }

    @Override
    public List<Policy> findSourceParameterizedPolicies(PolicyPointcutParameters policyPointcutParameters) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        if (!this.registeredPolicyInstanceProviders.isEmpty()) {
            for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
                if (!registeredPolicyInstanceProvider.getApplicationPolicyInstance().getPointcut().matches(policyPointcutParameters) || !registeredPolicyInstanceProvider.getApplicationPolicyInstance().getSourcePolicy().isPresent()) continue;
                policies.add(registeredPolicyInstanceProvider.getApplicationPolicyInstance().getSourcePolicy().get());
            }
        }
        return policies;
    }

    @Override
    public synchronized PolicyAwareAttributes sourcePolicyAwareAttributes() {
        return this.sourcePolicyAwareAttributes;
    }

    @Override
    public List<Policy> findOperationParameterizedPolicies(PolicyPointcutParameters policyPointcutParameters) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        if (!this.registeredPolicyInstanceProviders.isEmpty()) {
            for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
                if (!registeredPolicyInstanceProvider.getApplicationPolicyInstance().getPointcut().matches(policyPointcutParameters) || !registeredPolicyInstanceProvider.getApplicationPolicyInstance().getOperationPolicy().isPresent()) continue;
                policies.add(registeredPolicyInstanceProvider.getApplicationPolicyInstance().getOperationPolicy().get());
            }
        }
        return policies;
    }

    @Override
    public void dispose() {
        for (RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider : this.registeredPolicyInstanceProviders) {
            registeredPolicyInstanceProvider.getApplicationPolicyInstance().dispose();
        }
        this.registeredPolicyInstanceProviders.clear();
        for (RegisteredPolicyTemplate registeredPolicyTemplate : this.registeredPolicyTemplates) {
            try {
                registeredPolicyTemplate.policyTemplate.dispose();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.registeredPolicyTemplates.clear();
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    static String createPolicyAlreadyRegisteredError(String policyId) {
        return String.format("Policy already registered: '%s'", policyId);
    }

    static String createPolicyRegistrationError(String policyId) {
        return String.format("Error occured registering policy '%s'", policyId);
    }

    private static class RegisteredPolicyInstanceProvider
    implements Comparable<RegisteredPolicyInstanceProvider> {
        private final ApplicationPolicyInstance applicationPolicyInstance;
        private final String policyId;

        public RegisteredPolicyInstanceProvider(ApplicationPolicyInstance applicationPolicyInstance, String policyId) {
            this.applicationPolicyInstance = applicationPolicyInstance;
            this.policyId = policyId;
        }

        @Override
        public int compareTo(RegisteredPolicyInstanceProvider registeredPolicyInstanceProvider) {
            return Integer.compare(this.applicationPolicyInstance.getOrder(), registeredPolicyInstanceProvider.applicationPolicyInstance.getOrder());
        }

        public ApplicationPolicyInstance getApplicationPolicyInstance() {
            return this.applicationPolicyInstance;
        }

        public String getPolicyId() {
            return this.policyId;
        }
    }

    private static class RegisteredPolicyTemplate {
        private volatile int count;
        private final PolicyTemplate policyTemplate;

        private RegisteredPolicyTemplate(PolicyTemplate policyTemplate) {
            this.policyTemplate = policyTemplate;
        }
    }
}

