/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.FileUtils;

public class DeploymentPropertiesUtils {
    private static final String DEPLOYMENT_PROPERTIES_FILE_NAME = "deployment.properties";
    private static final String DEPLOYMENT_PROPERTIES_DIRECTORY = "deployment-properties";

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        File file = new File(MuleFoldersUtil.getExecutionFolder(), artifactName);
        String workingDirectory = file.getAbsolutePath();
        String deploymentPropertiesPath = workingDirectory + File.separator + DEPLOYMENT_PROPERTIES_DIRECTORY;
        if (!deploymentProperties.isPresent()) {
            return DeploymentPropertiesUtils.getDeploymentProperties(deploymentPropertiesPath);
        }
        DeploymentPropertiesUtils.initDeploymentPropertiesDirectory(deploymentPropertiesPath);
        DeploymentPropertiesUtils.persistDeploymentPropertiesFile(deploymentPropertiesPath, deploymentProperties.get());
        return deploymentProperties.get();
    }

    private static Properties getDeploymentProperties(String deploymentPropertiesPath) throws IOException {
        File configFile = new File(deploymentPropertiesPath + File.separator + DEPLOYMENT_PROPERTIES_FILE_NAME);
        Properties props = new Properties();
        if (!configFile.exists()) {
            return props;
        }
        FileReader reader = new FileReader(configFile);
        props.load(reader);
        return props;
    }

    private static void initDeploymentPropertiesDirectory(String deploymentPropertiesPath) {
        File deploymentPropertiesDirectory = FileUtils.newFile(deploymentPropertiesPath);
        if (!deploymentPropertiesDirectory.exists()) {
            DeploymentPropertiesUtils.createDeploymentPropertiesDirectory(deploymentPropertiesDirectory);
        }
    }

    private static synchronized void createDeploymentPropertiesDirectory(File deploymentPropertiesDirectory) {
        if (!deploymentPropertiesDirectory.exists() && !deploymentPropertiesDirectory.mkdirs()) {
            I18nMessage message = CoreMessages.failedToCreate("deployment properties directory " + deploymentPropertiesDirectory.getAbsolutePath());
            throw new MuleRuntimeException(message);
        }
    }

    private static void persistDeploymentPropertiesFile(String deploymentPropertiesPath, Properties deploymentProperties) throws IOException {
        File deploymentPropertiesFile = new File(deploymentPropertiesPath, DEPLOYMENT_PROPERTIES_FILE_NAME);
        FileWriter fileWriter = new FileWriter(deploymentPropertiesFile.getAbsolutePath(), false);
        deploymentProperties.store(fileWriter, "deployment properties");
        fileWriter.close();
    }
}

