/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.AbstractResourcesGenerator;
import org.mule.runtime.module.extension.internal.resources.ProcessingEnvironmentAware;

public final class AnnotationProcessorResourceGenerator
extends AbstractResourcesGenerator {
    private final ProcessingEnvironment processingEnv;

    public AnnotationProcessorResourceGenerator(List<GeneratedResourceFactory> resourceFactories, ProcessingEnvironment processingEnv) {
        super(AnnotationProcessorResourceGenerator.enrichFactories(resourceFactories, processingEnv));
        this.processingEnv = processingEnv;
    }

    @Override
    protected void write(GeneratedResource resource) {
        FileObject file;
        try {
            file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", resource.getPath(), new Element[0]);
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
        try (OutputStream out = file.openOutputStream();){
            out.write(resource.getContent());
            out.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e, resource);
        }
    }

    private RuntimeException wrapException(Exception e, GeneratedResource resource) {
        return new RuntimeException(String.format("Could not write generated resource '%s'", resource.getPath()), e);
    }

    private static Collection<GeneratedResourceFactory> enrichFactories(List<GeneratedResourceFactory> resourceFactories, ProcessingEnvironment processingEnv) {
        resourceFactories.forEach(factory -> {
            if (factory instanceof ProcessingEnvironmentAware) {
                ((ProcessingEnvironmentAware)((Object)factory)).setProcessingEnvironment(processingEnv);
            }
        });
        return resourceFactories;
    }
}

