/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedSourceCallbackExecutor
implements SourceCallbackExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposedSourceCallbackExecutor.class);
    private final SourceCallbackExecutor first;
    private final SourceCallbackExecutor then;

    ComposedSourceCallbackExecutor(SourceCallbackExecutor first, SourceCallbackExecutor then) {
        this.first = first;
        this.then = then;
    }

    @Override
    public void execute(final CoreEvent event, final Map<String, Object> parameters, final SourceCallbackContext context, final CompletableCallback<Void> callback) {
        this.first.execute(event, parameters, context, new CompletableCallback<Void>(){

            @Override
            public void complete(Void value) {
                ComposedSourceCallbackExecutor.this.then.execute(event, parameters, context, callback);
            }

            @Override
            public void error(final Throwable e) {
                ComposedSourceCallbackExecutor.this.then.execute(event, parameters, context, new CompletableCallback<Void>(){

                    @Override
                    public void complete(Void value) {
                        callback.error(e);
                    }

                    @Override
                    public void error(Throwable e2) {
                        LOGGER.error("Caught nested callback exception. Will Propagate the original one", e2);
                        callback.error(e);
                    }
                });
            }
        });
    }
}

