/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;

public class ReconnectionUtils {
    public static Consumer<Throwable> NULL_THROWABLE_CONSUMER = e -> {};

    public static boolean shouldRetry(Throwable t, ExecutionContextAdapter<?> context) {
        Optional<String> contextConfigName = context.getConfiguration().map(ConfigurationInstance::getName);
        Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(t);
        if (!connectionException.isPresent() || Boolean.valueOf((String)context.getVariable("MULE_DO_NOT_RETRY")).booleanValue()) {
            return false;
        }
        if (ReconnectionUtils.isPartOfActiveTransaction(context.getConfiguration().get())) {
            return false;
        }
        return ReconnectionUtils.isConnectionExceptionFromCurrentComponent(connectionException.get(), contextConfigName.orElse(null));
    }

    private static boolean isConnectionExceptionFromCurrentComponent(ConnectionException connectionException, String contextConfigName) {
        Boolean isTransactional = (Boolean)connectionException.getInfo().get("MULE_IS_TRANSACTIONAL");
        if (isTransactional != null && isTransactional.booleanValue()) {
            return false;
        }
        Object operationConfigName = connectionException.getInfo().get("MULE_COMPONENT_CONFIG_NAME");
        if (operationConfigName != null && contextConfigName != null) {
            return contextConfigName.equals(operationConfigName);
        }
        return true;
    }

    public static boolean isPartOfActiveTransaction(ConfigurationInstance configurationInstance) {
        if (TransactionCoordination.isTransactionActive()) {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            return tx != null && tx.hasResource(new ExtensionTransactionKey(configurationInstance));
        }
        return false;
    }
}

