/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressFilter;
import org.mule.service.http.impl.service.server.grizzly.MuleSslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    protected static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpServer.class);
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private GrizzlyAddressFilter<SSLFilter> sslFilter;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;
    private Supplier<Long> shutdownTimeoutSupplier;
    private volatile int openConnectionsCounter = 0;
    private final Object openConnectionsSync = new Object();
    private CountAcceptedConnectionsProbe acceptedConnectionsProbe;

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer, GrizzlyAddressFilter<SSLFilter> sslFilter, Supplier<Long> shutdownTimeoutSupplier) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
        this.sslFilter = sslFilter;
        this.shutdownTimeoutSupplier = shutdownTimeoutSupplier;
    }

    @Override
    public synchronized HttpServer start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.acceptedConnectionsProbe = new CountAcceptedConnectionsProbe();
        this.serverConnection.getMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{this.acceptedConnectionsProbe});
        if (logger.isInfoEnabled()) {
            logger.info("Listening for connections on '{}'", (Object)this.listenerUrl());
        }
        this.openConnectionsCounter = 0;
        this.serverConnection.addCloseListener((Connection.CloseListener)new OnCloseConnectionListener());
        this.stopped = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpServer stop() {
        if (this.stopped) {
            return this;
        }
        Long shutdownTimeout = this.shutdownTimeoutSupplier.get();
        long stopNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(shutdownTimeout);
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
            if (shutdownTimeout != 0L) {
                Object object = this.openConnectionsSync;
                synchronized (object) {
                    long remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    while (this.openConnectionsCounter != 0 && remainingMillis > 0L) {
                        long millisToWait = Math.min(remainingMillis, 50L);
                        logger.debug("There are still {} open connections on server stop. Waiting {} milliseconds", (Object)this.openConnectionsCounter, (Object)millisToWait);
                        this.openConnectionsSync.wait(millisToWait);
                        remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    }
                    if (this.openConnectionsCounter != 0) {
                        logger.warn("There are still {} open connections on server stop.", (Object)this.openConnectionsCounter);
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Stopped listener on '{}'", (Object)this.listenerUrl());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.stopped = true;
            this.stopping = false;
        }
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public HttpConstants.Protocol getProtocol() {
        return this.sslFilter.hasFilterForAddress(this.getServerAddress()) ? HttpConstants.Protocol.HTTPS : HttpConstants.Protocol.HTTP;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder(methods).build()).path(path).build());
    }

    @Override
    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }

    @Override
    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.sslFilter.addFilterForAddress(this.getServerAddress(), MuleSslFilter.createSslFilter(tlsContextFactory));
    }

    @Override
    public void disableTls() {
        this.sslFilter.removeFilterForAddress(this.getServerAddress());
    }

    private String listenerUrl() {
        return String.format("%s://%s:%d", this.getProtocol().getScheme(), this.serverAddress.getIp(), this.serverAddress.getPort());
    }

    private class OnCloseConnectionListener
    implements Connection.CloseListener {
        private OnCloseConnectionListener() {
        }

        public void onClosed(Connection closeable, Connection.CloseType type) throws IOException {
            try {
                if (GrizzlyHttpServer.this.scheduler != null) {
                    GrizzlyHttpServer.this.scheduler.stop();
                }
            }
            catch (Throwable throwable) {
                GrizzlyHttpServer.this.scheduler = null;
                GrizzlyHttpServer.this.schedulerDisposer.run();
                closeable.removeCloseListener((Connection.CloseListener)this);
                GrizzlyHttpServer.this.serverConnection.getMonitoringConfig().removeProbes((Object[])new ConnectionProbe[]{GrizzlyHttpServer.this.acceptedConnectionsProbe});
                GrizzlyHttpServer.this.acceptedConnectionsProbe = null;
                throw throwable;
            }
            GrizzlyHttpServer.this.scheduler = null;
            GrizzlyHttpServer.this.schedulerDisposer.run();
            closeable.removeCloseListener((Connection.CloseListener)this);
            GrizzlyHttpServer.this.serverConnection.getMonitoringConfig().removeProbes((Object[])new ConnectionProbe[]{GrizzlyHttpServer.this.acceptedConnectionsProbe});
            GrizzlyHttpServer.this.acceptedConnectionsProbe = null;
        }
    }

    private class CountAcceptedConnectionsProbe
    extends ConnectionProbe.Adapter {
        private CountAcceptedConnectionsProbe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
            Object object = GrizzlyHttpServer.this.openConnectionsSync;
            synchronized (object) {
                GrizzlyHttpServer.this.openConnectionsCounter = GrizzlyHttpServer.this.openConnectionsCounter + 1;
            }
            clientConnection.addCloseListener((closeable, iCloseType) -> {
                Object object = GrizzlyHttpServer.this.openConnectionsSync;
                synchronized (object) {
                    GrizzlyHttpServer.this.openConnectionsCounter = GrizzlyHttpServer.this.openConnectionsCounter - 1;
                    if (GrizzlyHttpServer.this.openConnectionsCounter == 0) {
                        GrizzlyHttpServer.this.openConnectionsSync.notifyAll();
                    }
                }
            });
        }
    }
}

