/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.api.connection.SourceRemoteConnectionException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseStreamingCompletionHandler
extends BaseResponseCompletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseStreamingCompletionHandler.class);
    private static boolean REPLACE_CONTEXT_CLASSLOADER = System.getProperty("mule.disableLogSeparation") == null;
    private final MemoryManager memoryManager;
    private final FilterChainContext ctx;
    private final ClassLoader ctxClassLoader;
    private final InputStream inputStream;
    private final ResponseStatusCallback responseStatusCallback;
    private final int bufferSize;
    private final long startTimeNanos;
    private static final String SELECTOR_TIMEOUT = "mule.timeoutToUseSelectorWhileStreamingResponseMillis";
    private final long selectorTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(Long.valueOf(System.getProperty("mule.timeoutToUseSelectorWhileStreamingResponseMillis", "50")));
    private volatile boolean isDone;

    public ResponseStreamingCompletionHandler(FilterChainContext ctx, ClassLoader ctxClassLoader, HttpRequestPacket request, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        Preconditions.checkArgument((boolean)httpResponse.getEntity().isStreaming(), (Object)"HTTP response entity must be stream based");
        this.ctx = ctx;
        this.ctxClassLoader = ctxClassLoader;
        this.httpResponsePacket = this.buildHttpResponsePacket(request, httpResponse);
        this.inputStream = httpResponse.getEntity().getContent();
        this.memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        this.bufferSize = this.calculateBufferSize(ctx, ctxClassLoader);
        this.responseStatusCallback = responseStatusCallback;
        this.startTimeNanos = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateBufferSize(FilterChainContext ctx, ClassLoader ctxClassLoader) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, ctxClassLoader);
        try {
            int bufferSize = DataUnit.KB.toBytes(8);
            String contentLengthHeader = this.httpResponsePacket.getHeader("Content-Length");
            int contentLength = !StringUtils.isEmpty(contentLengthHeader) ? Integer.valueOf(contentLengthHeader) : -1;
            if (contentLength > 0) {
                LOGGER.debug("Content length header present, calculating maximal buffer size.");
                bufferSize = Math.min(TCPNIOTransport.MAX_SEND_BUFFER_SIZE, Math.min(ctx.getConnection().getWriteBufferSize(), contentLength));
            } else {
                LOGGER.debug("Transfer encoding header present, using fixed buffer size.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response streaming chunk calculated buffer size = {} bytes.", (Object)bufferSize);
            }
            int n = bufferSize;
            return n;
        }
        finally {
            ClassUtils.setContextClassLoader(thread, ctxClassLoader, currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Thread thread = null;
        ClassLoader currentClassLoader = null;
        ClassLoader newClassLoader = null;
        if (REPLACE_CONTEXT_CLASSLOADER) {
            thread = Thread.currentThread();
            currentClassLoader = thread.getContextClassLoader();
            newClassLoader = this.getCtxClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, newClassLoader);
        }
        try {
            this.sendInputStreamChunk();
        }
        finally {
            if (REPLACE_CONTEXT_CLASSLOADER) {
                ClassUtils.setContextClassLoader(thread, newClassLoader, currentClassLoader);
            }
        }
    }

    public void sendInputStreamChunk() throws IOException {
        HttpTrailer content;
        int length;
        int offset;
        Buffer buffer = this.memoryManager.allocate(this.bufferSize);
        byte[] bufferByteArray = buffer.array();
        int bytesRead = this.inputStream.read(bufferByteArray, offset = buffer.arrayOffset(), length = buffer.remaining());
        if (bytesRead == -1) {
            content = this.httpResponsePacket.httpTrailerBuilder().build();
            this.isDone = true;
        } else {
            buffer.limit(bytesRead);
            content = this.httpResponsePacket.httpContentBuilder().content(buffer).build();
        }
        this.markConnectionToDelegateWritesInConfiguredExecutor(this.isSelectorTimeout());
        this.ctx.write((Object)content, (CompletionHandler)this);
    }

    private boolean isSelectorTimeout() {
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        return elapsedTimeNanos > this.selectorTimeoutNanos;
    }

    private void markConnectionToDelegateWritesInConfiguredExecutor(boolean value) {
        if (value) {
            this.ctx.getConnection().getAttributes().setAttribute("__WRITES_TO_IO__", (Object)true);
        } else {
            this.ctx.getConnection().getAttributes().removeAttribute("__WRITES_TO_IO__");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(WriteResult result) {
        Thread thread = null;
        ClassLoader currentClassLoader = null;
        ClassLoader newClassLoader = null;
        if (REPLACE_CONTEXT_CLASSLOADER) {
            thread = Thread.currentThread();
            currentClassLoader = thread.getContextClassLoader();
            newClassLoader = this.getCtxClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, newClassLoader);
        }
        try {
            if (!this.isDone) {
                this.sendInputStreamChunk();
                if (this.isDone && !this.httpResponsePacket.isChunked()) {
                    this.doComplete();
                }
            } else {
                this.doComplete();
            }
        }
        catch (IOException e) {
            this.failed(e);
        }
        finally {
            if (REPLACE_CONTEXT_CLASSLOADER) {
                ClassUtils.setContextClassLoader(thread, newClassLoader, currentClassLoader);
            }
        }
    }

    private void doComplete() {
        this.markConnectionToDelegateWritesInConfiguredExecutor(false);
        this.close();
        this.responseStatusCallback.responseSendSuccessfully();
        this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled() {
        Thread thread = null;
        ClassLoader currentClassLoader = null;
        ClassLoader newClassLoader = null;
        if (REPLACE_CONTEXT_CLASSLOADER) {
            thread = Thread.currentThread();
            currentClassLoader = thread.getContextClassLoader();
            newClassLoader = this.getCtxClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, newClassLoader);
        }
        try {
            super.cancelled();
            this.markConnectionToDelegateWritesInConfiguredExecutor(false);
            this.close();
            this.responseStatusCallback.responseSendFailure(new DefaultMuleException(CoreMessages.createStaticMessage("Http response sending task was cancelled")));
            this.resume();
        }
        finally {
            if (REPLACE_CONTEXT_CLASSLOADER) {
                ClassUtils.setContextClassLoader(thread, newClassLoader, currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable throwable) {
        Thread thread = null;
        ClassLoader currentClassLoader = null;
        ClassLoader newClassLoader = null;
        if (REPLACE_CONTEXT_CLASSLOADER) {
            thread = Thread.currentThread();
            currentClassLoader = thread.getContextClassLoader();
            newClassLoader = this.getCtxClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, newClassLoader);
        }
        try {
            super.failed(throwable);
            this.markConnectionToDelegateWritesInConfiguredExecutor(false);
            this.close();
            this.responseStatusCallback.onErrorSendingResponse(this.ctx.getConnection().isOpen() ? throwable : new SourceRemoteConnectionException("Client connection was closed", throwable));
            this.resume();
        }
        finally {
            if (REPLACE_CONTEXT_CLASSLOADER) {
                ClassUtils.setContextClassLoader(thread, newClassLoader, currentClassLoader);
            }
        }
    }

    private void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }

    @Override
    protected ClassLoader getCtxClassLoader() {
        return this.ctxClassLoader;
    }

    public static void setReplaceCtxClassloader(boolean replaceContextClassloader) {
        REPLACE_CONTEXT_CLASSLOADER = replaceContextClassloader;
    }
}

