/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.mule.apache.xerces.dom.CoreDocumentImpl;
import org.mule.apache.xerces.dom.PSVIAttrNSImpl;
import org.mule.apache.xerces.dom.PSVIDocumentImpl;
import org.mule.apache.xerces.dom.PSVIElementNSImpl;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.impl.xs.AbstractPsychoPathXPath2Impl;
import org.mule.apache.xerces.impl.xs.AttributePSVImpl;
import org.mule.apache.xerces.impl.xs.ElementPSVImpl;
import org.mule.apache.xerces.impl.xs.SchemaGrammar;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.XMLSchemaValidator;
import org.mule.apache.xerces.impl.xs.XSElementDecl;
import org.mule.apache.xerces.impl.xs.assertion.XMLAssertAdapter;
import org.mule.apache.xerces.impl.xs.assertion.XSAssert;
import org.mule.apache.xerces.impl.xs.assertion.XSAssertConstants;
import org.mule.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.mule.apache.xerces.impl.xs.util.ObjectListImpl;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.xni.Augmentations;
import org.mule.apache.xerces.xni.XMLAttributes;
import org.mule.apache.xerces.xni.XMLString;
import org.mule.apache.xerces.xs.ElementPSVI;
import org.mule.apache.xerces.xs.ItemPSVI;
import org.mule.apache.xerces.xs.XSComplexTypeDefinition;
import org.mule.apache.xerces.xs.XSModel;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLAssertPsychopathXPath2Impl
extends XMLAssertAdapter {
    private XSModel fSchemaXSmodel = null;
    private DynamicContext fXpath2DynamicContext;
    private AbstractPsychoPathXPath2Impl fAbstrPsychopathImpl = null;
    private Document fAssertDocument = new PSVIDocumentImpl();
    private Element fCurrentAssertDomNode = null;
    private Stack fAssertRootStack = new Stack();
    private Stack fAssertListStack = new Stack();
    private XMLSchemaValidator fXmlSchemaValidator = null;
    private Map fAssertParams = null;
    private XSAssert[] fFailedAssertions = null;
    private XSTypeDefinition fAssertRootTypeDef = null;

    public XMLAssertPsychopathXPath2Impl(Map assertParams) {
        this.fAssertParams = assertParams;
    }

    private void initXPathProcessor() throws Exception {
        this.fXmlSchemaValidator = (XMLSchemaValidator)this.getProperty("http://apache.org/xml/properties/assert/validator");
        this.fAbstrPsychopathImpl = new AbstractPsychoPathXPath2Impl();
        this.fXpath2DynamicContext = this.fAbstrPsychopathImpl.initXPath2DynamicContext(this.fSchemaXSmodel, this.fAssertDocument, this.fAssertParams);
    }

    @Override
    public void startElement(org.mule.apache.xerces.xni.QName element, XMLAttributes attributes, Augmentations augs) throws Exception {
        if (this.fCurrentAssertDomNode == null) {
            this.fCurrentAssertDomNode = new PSVIElementNSImpl((CoreDocumentImpl)this.fAssertDocument, element.uri, element.rawname);
            this.fAssertDocument.appendChild(this.fCurrentAssertDomNode);
        } else {
            PSVIElementNSImpl elem = new PSVIElementNSImpl((CoreDocumentImpl)this.fAssertDocument, element.uri, element.rawname);
            this.fCurrentAssertDomNode.appendChild(elem);
            this.fCurrentAssertDomNode = elem;
        }
        for (int attIndex = 0; attIndex < attributes.getLength(); ++attIndex) {
            PSVIAttrNSImpl attrNode = new PSVIAttrNSImpl((PSVIDocumentImpl)this.fAssertDocument, attributes.getURI(attIndex), attributes.getQName(attIndex), attributes.getLocalName(attIndex));
            attrNode.setNodeValue(attributes.getValue(attIndex));
            AttributePSVImpl attrPSVI = (AttributePSVImpl)attributes.getAugmentations(attIndex).getItem("ATTRIBUTE_PSVI");
            if (attrPSVI != null) {
                attrNode.setPSVI(attrPSVI);
            }
            this.fCurrentAssertDomNode.setAttributeNode(attrNode);
        }
        List assertionList = (List)augs.getItem(XSAssertConstants.assertList);
        if (assertionList != null) {
            this.fAssertRootStack.push(this.fCurrentAssertDomNode);
            this.fAssertListStack.push(assertionList);
            this.initXPathProcessor();
        }
        if (((Boolean)augs.getItem(XSAssertConstants.isAttrHaveAsserts)).booleanValue()) {
            this.evaluateAssertsFromAttributes(element, attributes);
        }
    }

    private void evaluateAssertsFromAttributes(org.mule.apache.xerces.xni.QName element, XMLAttributes attributes) throws Exception {
        for (int attrIdx = 0; attrIdx < attributes.getLength(); ++attrIdx) {
            List attrAssertList;
            org.mule.apache.xerces.xni.QName attrQname = new org.mule.apache.xerces.xni.QName();
            attributes.getName(attrIdx, attrQname);
            String attrValue = attributes.getValue(attrIdx);
            Augmentations attrAugs = attributes.getAugmentations(attrIdx);
            AttributePSVImpl attrPsvi = (AttributePSVImpl)attrAugs.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition attrSimpleType = (XSSimpleTypeDefinition)attrPsvi.getTypeDefinition();
            if (attrSimpleType == null || (attrAssertList = this.fXmlSchemaValidator.getAssertionValidator().getAssertsFromSimpleType(attrSimpleType)) == null) continue;
            boolean isTypeDerivedFromList = this.isTypeDerivedFromSTList(attrSimpleType);
            boolean isTypeDerivedFromUnion = this.isTypeDerivedFromSTUnion(attrSimpleType);
            for (int assertIdx = 0; assertIdx < attrAssertList.size(); ++assertIdx) {
                XSAssertImpl assertImpl = (XSAssertImpl)attrAssertList.get(assertIdx);
                assertImpl.setAttrName(attrQname.localpart);
                this.evaluateOneAssertionFromSimpleType(element, attrValue, attrAugs, attrSimpleType, isTypeDerivedFromList, isTypeDerivedFromUnion, assertImpl, true, attrQname);
                XSSimpleTypeDefinition attrItemType = attrSimpleType.getItemType();
                if (!isTypeDerivedFromList || attrItemType == null) continue;
                this.evaluateAssertsFromItemTypeOfSTList(element, attrItemType, attrValue);
            }
        }
    }

    @Override
    public void endElement(org.mule.apache.xerces.xni.QName element, Augmentations augs) throws Exception {
        if (this.fCurrentAssertDomNode != null) {
            ElementPSVI elemPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI");
            ((PSVIElementNSImpl)this.fCurrentAssertDomNode).setPSVI(elemPSVI);
            XSElementDecl elemDecl = (XSElementDecl)elemPSVI.getElementDeclaration();
            if (elemDecl != null && elemDecl.fDefault != null && !this.fCurrentAssertDomNode.hasChildNodes()) {
                this.fCurrentAssertDomNode.appendChild(this.fAssertDocument.createTextNode(elemDecl.fDefault.normalizedValue));
            }
            if (!this.fAssertRootStack.empty() && this.fCurrentAssertDomNode == this.fAssertRootStack.peek()) {
                this.fSchemaXSmodel = ((PSVIElementNSImpl)this.fCurrentAssertDomNode).getSchemaInformation();
                this.fAssertRootStack.pop();
                this.processAllAssertionsOnElement(element, (List)this.fAssertListStack.pop(), augs);
                if (this.fFailedAssertions != null && elemPSVI != null) {
                    this.setFailedAssertionsPSVIResult(elemPSVI);
                    this.fFailedAssertions = null;
                }
            }
            if (this.fCurrentAssertDomNode.getParentNode() instanceof Element) {
                this.fCurrentAssertDomNode = (Element)this.fCurrentAssertDomNode.getParentNode();
            }
        }
    }

    @Override
    public void comment(XMLString text) {
        if (this.fCurrentAssertDomNode != null) {
            this.fCurrentAssertDomNode.appendChild(this.fAssertDocument.createComment(new String(text.ch, text.offset, text.length)));
        }
    }

    @Override
    public void processingInstruction(String target, XMLString data) {
        if (this.fCurrentAssertDomNode != null) {
            this.fCurrentAssertDomNode.appendChild(this.fAssertDocument.createProcessingInstruction(target, new String(data.ch, data.offset, data.length)));
        }
    }

    private void setFailedAssertionsPSVIResult(ElementPSVI elemPSVI) {
        Object[] tempArray = new XSAssert[this.fFailedAssertions.length];
        System.arraycopy(this.fFailedAssertions, 0, tempArray, 0, this.fFailedAssertions.length);
        ((ElementPSVImpl)elemPSVI).fFailedAssertions = new ObjectListImpl(tempArray, tempArray.length);
    }

    private void processAllAssertionsOnElement(org.mule.apache.xerces.xni.QName element, List assertions, Augmentations augs) throws Exception {
        this.initXPathProcessor();
        ElementPSVI elemPsvi = (ElementPSVI)augs.getItem("ELEMENT_PSVI");
        String value = this.computeStringValueOf$value(this.fCurrentAssertDomNode, elemPsvi);
        if (assertions instanceof XSObjectList) {
            ElementPSVImpl modifiedRootNodePsvi = this.savePsviInfoWithUntypingOfAssertRoot(elemPsvi, true);
            this.evaluateAssertionsFromAComplexType(element, assertions, value, augs);
            this.restorePsviInfoForXPathContext(modifiedRootNodePsvi);
        } else if (assertions instanceof Vector) {
            this.evaluateAssertionsFromASimpleType(element, assertions, value, augs);
        }
    }

    private ElementPSVImpl savePsviInfoWithUntypingOfAssertRoot(ElementPSVI elemPsvi, boolean isSetXsAny) {
        ElementPSVImpl assertRootPsvi = new ElementPSVImpl(true, elemPsvi);
        this.fAssertRootTypeDef = assertRootPsvi.getTypeDefinition();
        if (isSetXsAny) {
            assertRootPsvi.fTypeDecl = new SchemaGrammar.XSAnyType();
            ((PSVIElementNSImpl)this.fCurrentAssertDomNode).setPSVI(assertRootPsvi);
        }
        return assertRootPsvi;
    }

    private void restorePsviInfoForXPathContext(ElementPSVI elemPsvi) {
        ElementPSVImpl assertRootPsvi = (ElementPSVImpl)elemPsvi;
        if (this.fAssertRootTypeDef != null) {
            assertRootPsvi.fTypeDecl = this.fAssertRootTypeDef;
            ((PSVIElementNSImpl)this.fCurrentAssertDomNode).setPSVI(assertRootPsvi);
        }
    }

    private void evaluateAssertionsFromASimpleType(org.mule.apache.xerces.xni.QName element, List assertions, String value, Augmentations augs) throws Exception {
        XSSimpleTypeDefinition simpleTypeDefn = (XSSimpleTypeDefinition)((ElementPSVI)augs.getItem("ELEMENT_PSVI")).getTypeDefinition();
        boolean isTypeDerivedFromList = this.isTypeDerivedFromSTList(simpleTypeDefn);
        boolean isTypeDerivedFromUnion = this.isTypeDerivedFromSTUnion(simpleTypeDefn);
        Vector assertList = (Vector)assertions;
        for (int assertIdx = 0; assertIdx < assertList.size(); ++assertIdx) {
            XSAssertImpl assertImpl = (XSAssertImpl)assertList.get(assertIdx);
            String xPathDefaultNamespace = assertImpl.getXPathDefaultNamespace();
            if (xPathDefaultNamespace != null) {
                this.fXpath2DynamicContext.add_namespace(null, xPathDefaultNamespace);
            }
            this.evaluateOneAssertionFromSimpleType(element, value, augs, simpleTypeDefn, isTypeDerivedFromList, isTypeDerivedFromUnion, assertImpl, false, null);
        }
        if (isTypeDerivedFromList && simpleTypeDefn.getItemType() != null) {
            this.evaluateAssertsFromItemTypeOfSTList(element, simpleTypeDefn.getItemType(), value);
        }
    }

    private void evaluateOneAssertionFromSimpleType(org.mule.apache.xerces.xni.QName element, String value, Augmentations augs, XSSimpleTypeDefinition simpleTypeDefn, boolean isTypeDerivedFromList, boolean isTypeDerivedFromUnion, XSAssertImpl assertImpl, boolean isAttribute, org.mule.apache.xerces.xni.QName attrQname) throws Exception {
        if (simpleTypeDefn.getVariety() == 1) {
            if (isAttribute) {
                this.setXDMTypedValueOf$value(this.fCurrentAssertDomNode, value, null, simpleTypeDefn, false, this.fXpath2DynamicContext);
            } else {
                this.setXDMTypedValueOf$value(this.fCurrentAssertDomNode, value, null, null, false, this.fXpath2DynamicContext);
            }
            AssertionError assertError = this.evaluateOneAssertion(element, assertImpl, value, false, false);
            if (assertError != null) {
                this.reportAssertionsError(assertError);
            }
        } else if (simpleTypeDefn.getVariety() == 2) {
            this.evaluateAssertionOnSTListValue(element, value, assertImpl, false, simpleTypeDefn.getItemType(), isTypeDerivedFromList);
        } else if (!isAttribute && ((Boolean)augs.getItem(XSAssertConstants.isAssertProcNeededForUnionElem)).booleanValue()) {
            if (!this.evaluateAssertionOnSTUnion(element, simpleTypeDefn, isTypeDerivedFromUnion, assertImpl, value, augs)) {
                this.fXmlSchemaValidator.reportSchemaError("cvc-type.3.1.3", new Object[]{element.rawname, value});
            }
        } else if (isAttribute && ((Boolean)augs.getItem(XSAssertConstants.isAssertProcNeededForUnionAttr)).booleanValue() && !this.evaluateAssertionOnSTUnion(element, simpleTypeDefn, isTypeDerivedFromUnion, assertImpl, value, augs)) {
            this.fXmlSchemaValidator.reportSchemaError("cvc-attribute.3", new Object[]{element.rawname, attrQname.localpart, value, ((XSSimpleTypeDecl)simpleTypeDefn).getTypeName()});
        }
    }

    private void evaluateAssertsFromItemTypeOfSTList(org.mule.apache.xerces.xni.QName element, XSSimpleTypeDefinition listItemType, String value) throws Exception {
        Vector itemTypeAsserts = XS11TypeHelper.getAssertsFromSimpleType(listItemType);
        if (listItemType.getVariety() == 1 && itemTypeAsserts.size() > 0) {
            for (int assertIdx = 0; assertIdx < itemTypeAsserts.size(); ++assertIdx) {
                XSAssertImpl itemTypeAssert = (XSAssertImpl)itemTypeAsserts.get(assertIdx);
                StringTokenizer listStrTokens = new StringTokenizer(value, " \n\t\r");
                while (listStrTokens.hasMoreTokens()) {
                    String listItemStrValue = listStrTokens.nextToken();
                    this.setXDMTypedValueOf$valueForSTVarietyList(this.fCurrentAssertDomNode, listItemStrValue, listItemType, false, this.fXpath2DynamicContext);
                    AssertionError assertError = this.evaluateOneAssertion(element, itemTypeAssert, listItemStrValue, false, true);
                    if (assertError == null) continue;
                    assertError.setIsTypeDerivedFromList(false);
                    this.reportAssertionsError(assertError);
                }
            }
        }
    }

    private void evaluateAssertionOnSTListValue(org.mule.apache.xerces.xni.QName element, String listStrValue, XSAssertImpl assertImpl, boolean xpathContextExists, XSSimpleTypeDefinition itemType, boolean isTypeDerivedFromList) throws Exception {
        AssertionError assertError = null;
        if (isTypeDerivedFromList) {
            this.setXDMTypedValueOf$valueForSTVarietyList(this.fCurrentAssertDomNode, listStrValue, itemType, isTypeDerivedFromList, this.fXpath2DynamicContext);
            assertError = this.evaluateOneAssertion(element, assertImpl, listStrValue, xpathContextExists, true);
            if (assertError != null) {
                assertError.setIsTypeDerivedFromList(isTypeDerivedFromList);
                this.reportAssertionsError(assertError);
            }
        } else {
            StringTokenizer listStrTokens = new StringTokenizer(listStrValue, " \n\t\r");
            while (listStrTokens.hasMoreTokens()) {
                String listItemStrValue = listStrTokens.nextToken();
                this.setXDMTypedValueOf$valueForSTVarietyList(this.fCurrentAssertDomNode, listItemStrValue, itemType, isTypeDerivedFromList, this.fXpath2DynamicContext);
                assertError = this.evaluateOneAssertion(element, assertImpl, listItemStrValue, xpathContextExists, true);
                if (assertError == null) continue;
                this.reportAssertionsError(assertError);
            }
        }
    }

    private boolean evaluateAssertionOnSTUnion(org.mule.apache.xerces.xni.QName element, XSSimpleTypeDefinition simpleTypeDefn, boolean isTypeDerivedFromUnion, XSAssertImpl assertImpl, String value, Augmentations augs) throws Exception {
        boolean isValueValid = true;
        XSObjectList memberTypes = simpleTypeDefn.getMemberTypes();
        if (memberTypes != null && memberTypes.getLength() > 0 && !isTypeDerivedFromUnion) {
            if (this.isValidationFailedForSTUnion(memberTypes, element, value, augs)) {
                isValueValid = false;
                if (assertImpl.getAttrName() == null) {
                    this.fXmlSchemaValidator.reportSchemaError("cvc-assertions-valid-union-elem", new Object[]{value, element.rawname, ((XSSimpleTypeDecl)simpleTypeDefn).getTypeName()});
                } else {
                    this.fXmlSchemaValidator.reportSchemaError("cvc-assertions-valid-union-attr", new Object[]{value, assertImpl.getAttrName(), element.rawname, ((XSSimpleTypeDecl)simpleTypeDefn).getTypeName()});
                }
                this.fXmlSchemaValidator.reportSchemaError("cvc-datatype-valid.1.2.3", new Object[]{value, ((XSSimpleTypeDecl)simpleTypeDefn).getTypeName()});
            }
        } else if (isTypeDerivedFromUnion) {
            this.setXDMTypedValueOf$valueForSTVarietyUnion(value, memberTypes, this.fXpath2DynamicContext);
            AssertionError assertError = this.evaluateOneAssertion(element, assertImpl, value, false, false);
            if (assertError != null) {
                isValueValid = false;
                this.reportAssertionsError(assertError);
            }
        }
        return isValueValid;
    }

    private void evaluateAssertionsFromAComplexType(org.mule.apache.xerces.xni.QName element, List assertions, String value, Augmentations augs) throws Exception {
        ElementPSVI elemPsvi = (ElementPSVI)augs.getItem("ELEMENT_PSVI");
        if (value != null) {
            this.restorePsviInfoForXPathContext(elemPsvi);
            this.setXDMValueOf$valueForCTWithSimpleContent(value, (XSComplexTypeDefinition)elemPsvi.getTypeDefinition(), this.fXpath2DynamicContext);
            this.savePsviInfoWithUntypingOfAssertRoot(elemPsvi, true);
        } else {
            this.fXpath2DynamicContext.set_variable(new QName("value"), XS11TypeHelper.getXPath2ResultSequence(new ArrayList()));
        }
        XSObjectList assertList = (XSObjectList)assertions;
        for (int assertIdx = 0; assertIdx < assertList.size(); ++assertIdx) {
            XSAssertImpl assertImpl = (XSAssertImpl)assertList.get(assertIdx);
            String xPathDefaultNamespace = assertImpl.getXPathDefaultNamespace();
            if (xPathDefaultNamespace != null) {
                this.fXpath2DynamicContext.add_namespace(null, xPathDefaultNamespace);
            }
            if (assertImpl.getType() == 16) {
                AssertionError assertError = this.evaluateOneAssertion(element, assertImpl, value, true, false);
                if (assertError == null) continue;
                this.reportAssertionsError(assertError);
                continue;
            }
            if (assertImpl.getAttrName() != null) continue;
            XSSimpleTypeDefinition simpleTypeDefn = null;
            XSTypeDefinition xsTypeDefn = assertImpl.getTypeDefinition();
            simpleTypeDefn = xsTypeDefn instanceof XSComplexTypeDefinition ? ((XSComplexTypeDefinition)xsTypeDefn).getSimpleType() : (XSSimpleTypeDefinition)xsTypeDefn;
            XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)elemPsvi.getTypeDefinition();
            if (XS11TypeHelper.isComplexTypeDerivedFromSTList(complexTypeDef, (short)1)) {
                simpleTypeDefn = (XSSimpleTypeDefinition)complexTypeDef.getBaseType();
            }
            boolean isTypeDerivedFromList = this.isTypeDerivedFromSTList(simpleTypeDefn);
            boolean isTypeDerivedFromUnion = this.isTypeDerivedFromSTUnion(simpleTypeDefn);
            this.restorePsviInfoForXPathContext(elemPsvi);
            this.evaluateOneAssertionFromSimpleType(element, value, augs, simpleTypeDefn, isTypeDerivedFromList, isTypeDerivedFromUnion, assertImpl, false, null);
            this.savePsviInfoWithUntypingOfAssertRoot(elemPsvi, true);
            XSSimpleTypeDefinition listItemType = simpleTypeDefn.getItemType();
            if (!isTypeDerivedFromList || listItemType == null) continue;
            this.restorePsviInfoForXPathContext(elemPsvi);
            this.evaluateAssertsFromItemTypeOfSTList(element, listItemType, value);
            this.savePsviInfoWithUntypingOfAssertRoot(elemPsvi, true);
        }
    }

    private AssertionError evaluateOneAssertion(org.mule.apache.xerces.xni.QName element, XSAssertImpl assertImpl, String value, boolean xPathContextExists, boolean isList) {
        AssertionError assertionError = null;
        try {
            XPath xpathObject = assertImpl.getCompiledXPathExpr();
            boolean result = value == null || xPathContextExists ? this.fAbstrPsychopathImpl.evaluateXPathExpr(xpathObject, this.fCurrentAssertDomNode) : this.fAbstrPsychopathImpl.evaluateXPathExpr(xpathObject, null);
            if (!result) {
                assertionError = new AssertionError("cvc-assertion", element, assertImpl, value, isList, null);
            }
        }
        catch (Exception ex) {
            assertionError = new AssertionError("cvc-assertion", element, assertImpl, value, isList, ex);
        }
        if (assertionError != null && assertImpl.getAttrName() == null) {
            if (this.fFailedAssertions == null) {
                this.fFailedAssertions = new XSAssertImpl[1];
            } else {
                XSAssertImpl[] tempArray = new XSAssertImpl[this.fFailedAssertions.length + 1];
                System.arraycopy(this.fFailedAssertions, 0, tempArray, 0, this.fFailedAssertions.length);
                this.fFailedAssertions = tempArray;
            }
            this.fFailedAssertions[this.fFailedAssertions.length - 1] = assertImpl;
        }
        return assertionError;
    }

    private boolean isValidationFailedForSTUnion(XSObjectList memberTypes, org.mule.apache.xerces.xni.QName element, String value, Augmentations augs) {
        boolean isValidationFailedForUnion = true;
        for (int memberTypeIdx = 0; memberTypeIdx < memberTypes.getLength(); ++memberTypeIdx) {
            XSSimpleTypeDefinition memType = (XSSimpleTypeDefinition)memberTypes.item(memberTypeIdx);
            if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(memType.getNamespace())) continue;
            if (!XS11TypeHelper.simpleTypeHasAsserts(memType) && XS11TypeHelper.isStrValueValidForASimpleType(value, (XSSimpleType)memType, (short)4)) {
                isValidationFailedForUnion = false;
                break;
            }
            XSObjectList memberTypeFacets = memType.getMultiValueFacets();
            for (int memberTypeFacetIdx = 0; memberTypeFacetIdx < memberTypeFacets.getLength(); ++memberTypeFacetIdx) {
                XSMultiValueFacet facet = (XSMultiValueFacet)memberTypeFacets.item(memberTypeFacetIdx);
                if (facet.getFacetKind() != 16384) continue;
                Vector assertFacets = facet.getAsserts();
                int assertsSucceeded = 0;
                for (XSAssertImpl assertImpl : assertFacets) {
                    try {
                        this.setXDMTypedValueOf$value(this.fCurrentAssertDomNode, value, memType, null, false, this.fXpath2DynamicContext);
                        AssertionError assertError = this.evaluateOneAssertion(element, assertImpl, value, false, false);
                        if (assertError != null) continue;
                        ++assertsSucceeded;
                    }
                    catch (Exception ex) {}
                }
                if (assertsSucceeded != assertFacets.size()) continue;
                ItemPSVI elemPSVI = (ItemPSVI)augs.getItem("ELEMENT_PSVI");
                ItemPSVI attrPSVI = (ItemPSVI)augs.getItem("ATTRIBUTE_PSVI");
                if (elemPSVI != null) {
                    ((ElementPSVImpl)elemPSVI).fValue.memberType = (XSSimpleType)memType;
                } else {
                    ((AttributePSVImpl)attrPSVI).fValue.memberType = (XSSimpleType)memType;
                }
                isValidationFailedForUnion = false;
                break;
            }
            if (!isValidationFailedForUnion) break;
        }
        return isValidationFailedForUnion;
    }

    @Override
    public void characters(XMLString text) {
        if (this.fCurrentAssertDomNode != null) {
            this.fCurrentAssertDomNode.appendChild(this.fAssertDocument.createTextNode(new String(text.ch, text.offset, text.length)));
        }
    }

    private void reportAssertionsError(AssertionError assertError) {
        String key = assertError.getErrorCode();
        org.mule.apache.xerces.xni.QName element = assertError.getElement();
        XSAssertImpl assertImpl = assertError.getAssertion();
        boolean isList = assertError.isList();
        String value = assertError.getValue();
        String exceptionMesg = "";
        Exception exception = assertError.getException();
        if (exception instanceof DynamicError) {
            exceptionMesg = ((DynamicError)exception).code() + " - " + ((DynamicError)exception).getMessage();
        } else if (exception instanceof StaticError) {
            exceptionMesg = ((StaticError)exception).code() + " - " + ((StaticError)exception).getMessage();
        }
        if (!"".equals(exceptionMesg) && !exceptionMesg.endsWith(".")) {
            exceptionMesg = exceptionMesg + ".";
        }
        String typeNameStr = XS11TypeHelper.getSchemaTypeName(assertImpl.getTypeDefinition());
        String elemNameAnnotation = element.rawname;
        if (assertImpl.getAttrName() != null) {
            elemNameAnnotation = element.rawname + " (attribute => " + assertImpl.getAttrName() + ")";
        }
        String listAssertErrMessage = "";
        if (isList) {
            listAssertErrMessage = assertError.getIsTypeDerivedFromList() ? "Assertion failed for xs:list instance '" + value + "'." : "Assertion failed for an xs:list member value '" + value + "'.";
        }
        String mesgSuffix = "".equals(listAssertErrMessage) ? exceptionMesg : listAssertErrMessage + ("".equals(exceptionMesg) ? "" : " " + exceptionMesg);
        String userDefinedMessage = assertImpl.getMessage();
        if (userDefinedMessage != null) {
            if (value != null && !"".equals(value)) {
                userDefinedMessage = userDefinedMessage.replaceAll("\\{\\$value\\}", value);
            }
            if (!userDefinedMessage.endsWith(".")) {
                userDefinedMessage = userDefinedMessage + ".";
            }
            userDefinedMessage = "Assertion failed for schema type '" + typeNameStr + "'. " + userDefinedMessage;
            this.fXmlSchemaValidator.reportSchemaError("cvc-assertion-failure-mesg", new Object[]{userDefinedMessage, mesgSuffix});
        } else if (assertImpl.getAssertKind() == 16) {
            this.fXmlSchemaValidator.reportSchemaError(key, new Object[]{elemNameAnnotation, assertImpl.getTest().getXPathStr(), typeNameStr, mesgSuffix});
        } else {
            this.fXmlSchemaValidator.reportSchemaError("cvc-assertions-valid", new Object[]{value, assertImpl.getTest().getXPathStr(), exceptionMesg});
            this.fXmlSchemaValidator.reportSchemaError(key, new Object[]{elemNameAnnotation, assertImpl.getTest().getXPathStr(), typeNameStr, mesgSuffix});
        }
    }

    private boolean isTypeDerivedFromSTList(XSSimpleTypeDefinition simpleTypeDefn) {
        return ((XSSimpleType)simpleTypeDefn.getBaseType()).getVariety() == 2;
    }

    private boolean isTypeDerivedFromSTUnion(XSSimpleTypeDefinition simpleTypeDefn) {
        return ((XSSimpleType)simpleTypeDefn.getBaseType()).getVariety() == 3;
    }

    final class AssertionError {
        private final String errorCode;
        private final org.mule.apache.xerces.xni.QName element;
        private final XSAssertImpl assertImpl;
        private final String value;
        private final boolean isList;
        private boolean isTypeDerivedFromList = false;
        Exception ex = null;

        public AssertionError(String errorCode, org.mule.apache.xerces.xni.QName element, XSAssertImpl assertImpl, String value, boolean isList, Exception ex) {
            this.errorCode = errorCode;
            this.element = element;
            this.assertImpl = assertImpl;
            this.value = value;
            this.isList = isList;
            this.ex = ex;
        }

        public void setIsTypeDerivedFromList(boolean isTypeDerivedFromList) {
            this.isTypeDerivedFromList = isTypeDerivedFromList;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public org.mule.apache.xerces.xni.QName getElement() {
            return this.element;
        }

        public XSAssertImpl getAssertion() {
            return this.assertImpl;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isList() {
            return this.isList;
        }

        public boolean getIsTypeDerivedFromList() {
            return this.isTypeDerivedFromList;
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

