/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class DslElementIdHelper {
    static String getSourceElementName(DslElementModel<?> elementModel) {
        return elementModel.getDsl().getPrefix() + ":" + DslElementIdHelper.getModelName(elementModel.getModel()).orElse(elementModel.getDsl().getElementName()) + elementModel.getConfiguration().map(c -> c.getParameters().get("name")).filter(Objects::nonNull).map(n -> "[" + n + "]").orElse("");
    }

    static Optional<String> getModelName(Object model) {
        if (model instanceof NamedObject) {
            return Optional.of(((NamedObject)model).getName());
        }
        if (model instanceof ObjectType) {
            return ExtensionMetadataTypeUtils.getId((MetadataType)model);
        }
        return Optional.empty();
    }

    static String sourceElementNameFromSimpleValue(DslElementModel<?> element) {
        return DslElementIdHelper.getModelName(element.getModel()).map(modelName -> StringUtils.isBlank(element.getDsl().getPrefix()) ? modelName : element.getDsl().getPrefix() + ":" + modelName).orElseGet(() -> element.getIdentifier().map(Object::toString).orElse(null));
    }

    static Optional<String> resolveConfigName(DslElementModel<?> elementModel) {
        String configRef;
        Optional<ComponentConfiguration> configuration = elementModel.getConfiguration();
        if (configuration.isPresent() && !StringUtils.isBlank(configRef = configuration.get().getParameters().get("config-ref"))) {
            return Optional.of(configRef);
        }
        return Optional.empty();
    }
}

