/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.policy.OnExecuteNextErrorConsumer;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.internal.policy.PolicyTraceLogger;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PolicyNextActionMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    static final String SOURCE_POLICY_PART_IDENTIFIER = "source";
    public static final String POLICY_NEXT_OPERATION = "policy.nextOperation";
    public static final String POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS = "policy.isPropagateMessageTransformations";
    @Inject
    private MuleContext muleContext;
    @Inject
    private ServerNotificationHandler notificationManager;
    private PolicyNotificationHelper notificationHelper;
    private PolicyEventMapper policyEventMapper;
    private final PolicyTraceLogger policyTraceLogger = new PolicyTraceLogger();
    private OnExecuteNextErrorConsumer onExecuteNextErrorConsumer;
    private MessageProcessorChain nextDispatchAsChain;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.policyEventMapper = new PolicyEventMapper(this.getPolicyId());
        this.notificationHelper = new PolicyNotificationHelper(this.notificationManager, this.getPolicyId(), this);
        this.onExecuteNextErrorConsumer = this.errorConsumer(this.policyEventMapper, this.notificationHelper);
        this.nextDispatchAsChain = MessageProcessors.buildNewChainWithListOfProcessors(Optional.empty(), Collections.singletonList(new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPub) {
                return Mono.subscriberContext().flatMapMany(ctx -> Flux.from((Publisher)eventPub).map(event -> ctx.hasKey((Object)PolicyNextActionMessageProcessor.POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS) ? PolicyNextActionMessageProcessor.this.policyEventMapper.onSourcePolicyNext((CoreEvent)event, (Boolean)ctx.get((Object)PolicyNextActionMessageProcessor.POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS)) : PolicyNextActionMessageProcessor.this.policyEventMapper.onOperationPolicyNext((CoreEvent)event)).transform((Function)((ReactiveProcessor)((Reference)ctx.get((Object)PolicyNextActionMessageProcessor.POLICY_NEXT_OPERATION)).get())));
            }
        }), this.policyNextErrorHandler());
        LifecycleUtils.initialiseIfNeeded(this.nextDispatchAsChain, this.muleContext);
    }

    private OnExecuteNextErrorConsumer errorConsumer(PolicyEventMapper policyEventMapper, PolicyNotificationHelper notificationHelper) {
        if (this.isWithinSourcePolicy(this.getLocation()).booleanValue()) {
            return new OnExecuteNextErrorConsumer(me -> {
                CoreEvent event = me.getEvent();
                if (me.getFailingComponent() != null && this.isWithinSourcePolicy(me.getFailingComponent().getLocation()).booleanValue()) {
                    return policyEventMapper.fromPolicyNext(event);
                }
                return policyEventMapper.fromPolicyNext(policyEventMapper.onFlowError(event, this.getPolicyId(), SourcePolicyContext.from(event).getParametersTransformer()));
            }, notificationHelper, this.getLocation());
        }
        return new OnExecuteNextErrorConsumer(me -> policyEventMapper.fromPolicyNext(me.getEvent()), notificationHelper, this.getLocation());
    }

    private Boolean isWithinSourcePolicy(ComponentLocation loc) {
        return loc.getParts().size() >= 2 && loc.getParts().get(1).getPartIdentifier().map(tci -> tci.getIdentifier().getName().equals(SOURCE_POLICY_PART_IDENTIFIER)).orElse(false) != false;
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).doOnNext(event -> this.policyTraceLogger.logBeforeExecuteNext(this.getPolicyId(), (CoreEvent)event)).doOnNext(event -> {
            PolicyNextActionMessageProcessor.popBeforeNextFlowFlowStackElement().accept((CoreEvent)event);
            this.notificationHelper.notification(2102).accept((CoreEvent)event);
        }).compose((Function)this.nextDispatchAsChain).doOnNext(coreEvent -> {
            this.notificationHelper.fireNotification((CoreEvent)coreEvent, null, 2103);
            this.pushAfterNextFlowStackElement().accept((CoreEvent)coreEvent);
        }).map(this.policyEventMapper::fromPolicyNext).doOnNext(event -> this.policyTraceLogger.logAfterExecuteNext(this.getPolicyId(), (CoreEvent)event));
    }

    private BaseExceptionHandler policyNextErrorHandler() {
        return new BaseExceptionHandler(){

            @Override
            public void onError(Exception error) {
                PolicyNextActionMessageProcessor.this.onExecuteNextErrorConsumer.accept(error);
            }

            public String toString() {
                return PolicyNextActionMessageProcessor.class.getSimpleName() + ".errorHandler @ " + PolicyNextActionMessageProcessor.this.getLocation().getLocation();
            }
        };
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(PolicyNextActionMessageProcessor.toPolicyLocation(this.getLocation()), null));
    }

    private static String toPolicyLocation(ComponentLocation componentLocation) {
        return componentLocation.getParts().get(0).getPartPath() + "/" + componentLocation.getParts().get(1).getPartPath() + "[after next]";
    }

    private static Consumer<CoreEvent> popBeforeNextFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    private String getPolicyId() {
        return this.muleContext.getConfiguration().getId();
    }
}

