/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.context.thread.notification.ThreadNotificationLogger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class InterceptedReactiveProcessor
implements ReactiveProcessor {
    private final Processor processor;
    private final ReactiveProcessor next;
    private final ReactiveProcessor.ProcessingType processingType;
    private final ThreadNotificationLogger threadNotificationLogger;

    public InterceptedReactiveProcessor(Processor processor, ReactiveProcessor next, ThreadNotificationLogger threadNotificationLogger) {
        this.processor = processor;
        this.processingType = processor.getProcessingType();
        this.next = next;
        this.threadNotificationLogger = threadNotificationLogger;
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPublisher) {
        Flux flux = Flux.from(eventPublisher);
        if (this.processor instanceof Component && ((Component)((Object)this.processor)).getLocation() != null) {
            flux = flux.checkpoint(((Component)((Object)this.processor)).getLocation().getLocation());
        }
        if (this.threadNotificationLogger != null) {
            return flux.doOnNext(event -> this.threadNotificationLogger.setFinishThread(event.getContext().getId())).transform(publisher -> (Publisher)this.next.apply(publisher)).doOnNext(event -> this.threadNotificationLogger.setStartingThread(event.getContext().getId()));
        }
        return flux.transform(publisher -> (Publisher)this.next.apply(publisher));
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        return this.processingType;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return this.processor instanceof Component ? ((Component)((Object)this.processor)).getLocation().getLocation() : this.processor.toString();
    }
}

