/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.construct;

import java.util.List;
import javax.inject.Inject;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ProcessorChainValueResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class RouteComponentObjectFactory
extends AbstractExtensionObjectFactory<Object> {
    private DefaultObjectBuilder builder;
    private final NestedRouteModel model;
    private Class<Object> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private final List<Processor> nestedProcessors;
    private final Once.RunOnce initialiser;
    @Inject
    private ReflectionCache reflectionCache;

    public RouteComponentObjectFactory(NestedRouteModel model, ObjectType objectType, ClassLoader classLoader, MuleContext muleContext, List<Processor> nestedProcessors) {
        super(muleContext);
        this.classLoader = classLoader;
        this.model = model;
        this.objectType = objectType;
        this.nestedProcessors = nestedProcessors;
        this.initialiser = Once.of(() -> {
            this.objectClass = JavaTypeUtils.getType(objectType);
            this.builder = new DefaultObjectBuilder<Object>(this.objectClass, this.reflectionCache);
        });
    }

    @Override
    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.initialiser.runOnce();
            if (this.nestedProcessors != null) {
                StreamingManager streamingManager = ((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(StreamingManager.class);
                this.model.getNestedComponents().stream().filter(component -> component instanceof NestedChainModel).findFirst().ifPresent(chain -> this.parameters.put(chain.getName(), new ProcessorChainValueResolver(streamingManager, this.muleContext, this.nestedProcessors)));
            }
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            return new ObjectBuilderValueResolver(this.builder, this.muleContext);
        }, Exception.class, exception -> {
            throw exception;
        });
    }
}

