/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.util.OptionalLong;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResponseCompletionHandler
extends EmptyCompletionHandler<WriteResult> {
    public static final String CLIENT_CONNECTION_CLOSED_MESSAGE = "Client connection was closed";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResponseCompletionHandler.class);
    private static final String MULTIPART_CONTENT_TYPE_FORMAT = "%s; %s=\"%s\"";
    protected boolean hasContentLength = false;
    protected HttpResponsePacket httpResponsePacket = null;

    protected HttpResponsePacket buildHttpResponsePacket(HttpRequestPacket sourceRequest, HttpResponse httpResponse) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)sourceRequest).status(httpResponse.getStatusCode()).reasonPhrase(httpResponse.getReasonPhrase());
        String contentType = null;
        String connectionHeaderValue = null;
        boolean hasTransferEncoding = false;
        boolean hasConnection = false;
        for (String headerName : httpResponse.getHeaderNames()) {
            boolean specialHeader = false;
            if (contentType == null && headerName.equalsIgnoreCase("Content-Type")) {
                contentType = httpResponse.getHeaderValue(headerName);
                specialHeader = true;
                responsePacketBuilder.header("Content-Type", httpResponse.getHeaderValue(headerName));
            }
            if (!hasTransferEncoding && headerName.equalsIgnoreCase("Transfer-Encoding")) {
                hasTransferEncoding = true;
                specialHeader = true;
                responsePacketBuilder.header("Transfer-Encoding", httpResponse.getHeaderValue(headerName));
            }
            if (!hasConnection && headerName.equalsIgnoreCase("Connection")) {
                hasConnection = true;
                specialHeader = true;
                connectionHeaderValue = httpResponse.getHeaderValue(headerName);
                responsePacketBuilder.header("Connection", connectionHeaderValue);
            }
            if (!this.hasContentLength && headerName.equalsIgnoreCase("Content-Length")) {
                this.hasContentLength = true;
                specialHeader = true;
                responsePacketBuilder.header("Content-Length", httpResponse.getHeaderValue(headerName));
            }
            if (specialHeader) continue;
            for (String value : httpResponse.getHeaderValues(headerName)) {
                responsePacketBuilder.header(headerName, value);
            }
        }
        if (httpResponse.getEntity().isComposed()) {
            if (contentType == null) {
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, "multipart/form-data", "boundary", UUID.getUUID()));
            } else if (!contentType.contains("boundary")) {
                responsePacketBuilder.removeHeader("Content-Type");
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, contentType, "boundary", UUID.getUUID()));
            }
        }
        OptionalLong length = httpResponse.getEntity().getBytesLength();
        Protocol protocol = sourceRequest.getProtocol();
        if (!hasTransferEncoding && !this.hasContentLength && length.isPresent() && !protocol.equals((Object)Protocol.HTTP_1_0)) {
            responsePacketBuilder.header("Content-Length", String.valueOf(length.getAsLong()));
        }
        HttpResponsePacket httpResponsePacket = responsePacketBuilder.build();
        httpResponsePacket.setProtocol(protocol);
        if (hasTransferEncoding) {
            httpResponsePacket.setChunked(true);
        }
        if (hasConnection && "close".equalsIgnoreCase(connectionHeaderValue)) {
            httpResponsePacket.getProcessingState().setKeepAlive(false);
        }
        return httpResponsePacket;
    }

    public void cancelled() {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getCtxClassLoader());
        try {
            LOGGER.warn("HTTP response sending task was cancelled");
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable throwable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        ClassLoader ctxClassLoader = this.getCtxClassLoader();
        ClassUtils.setContextClassLoader(currentThread, originalClassLoader, ctxClassLoader);
        try {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("HTTP response sending task failed with error: %s", throwable.getMessage()));
            }
        }
        finally {
            ClassUtils.setContextClassLoader(currentThread, ctxClassLoader, originalClassLoader);
        }
    }

    protected abstract ClassLoader getCtxClassLoader();

    public HttpResponsePacket getHttpResponsePacket() {
        return this.httpResponsePacket;
    }
}

