/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.util.regex.Pattern;
import org.mule.weave.v2.grammar.Identifiers$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;

public final class NameIdentifierHelper$ {
    public static NameIdentifierHelper$ MODULE$;
    private final Pattern VALID_IDENTIFIER_PATTERN;

    static {
        new NameIdentifierHelper$();
    }

    public String toWeaveFilePath(NameIdentifier name) {
        return new StringBuilder(1).append("/").append(name.name().replaceAll("::", "/")).append(WeaveFile$.MODULE$.fileExtension()).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public NameIdentifier fromWeaveFilePath(String name) {
        NameIdentifier nameIdentifier;
        String path = name;
        Option<String> mayBeExtension = this.getExtension(name);
        if (mayBeExtension.isDefined()) {
            path = path.substring(0, name.length() - ((String)mayBeExtension.get()).length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (mayBeExtension.isDefined()) {
            Object object = mayBeExtension.get();
            String string = WeaveFile$.MODULE$.fileExtension();
            if (!(object != null ? !object.equals(string) : string != null)) {
                nameIdentifier = new NameIdentifier(path.replaceAll("/", "::"), NameIdentifier$.MODULE$.apply$default$2());
                return nameIdentifier;
            }
        }
        nameIdentifier = new NameIdentifier(path.replaceAll("/", "::"), (Option<String>)mayBeExtension.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.substring(1)));
        return nameIdentifier;
    }

    private Option<String> getExtension(String name) {
        return name.lastIndexOf(46) >= 0 ? new Some(new StringOps(Predef$.MODULE$.augmentString(name)).drop(name.lastIndexOf(46))) : None$.MODULE$;
    }

    public Pattern VALID_IDENTIFIER_PATTERN() {
        return this.VALID_IDENTIFIER_PATTERN;
    }

    public boolean isValidIdentifier(String name) {
        return this.VALID_IDENTIFIER_PATTERN().matcher(name).matches() && !Identifiers$.MODULE$.keywords().contains((Object)name);
    }

    private NameIdentifierHelper$() {
        MODULE$ = this;
        this.VALID_IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    }
}

