/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.runtime.api.exception.DefaultExceptionReader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.NamingExceptionReader;
import org.mule.runtime.api.legacy.exception.ExceptionReader;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.internal.exception.SuppressedMuleException;

public class ExceptionHelper {
    private static final String MULE_PACKAGE_REGEXP = "(?:org|com)\\.mule(?:soft)?\\.(?!mvel2)(?!el).*";
    private static final int ALREADY_FILTERED_INDICATOR = -3;
    public static final String[] DEFAULT_STACKTRACE_FILTER = new String[]{"org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor", "org.mule.runtime.core.privileged.processor.chain", "org.mule.runtime.core.internal.processor.chain", "reactor.core"};
    private static final int EXCEPTION_THRESHOLD = 3;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static List<ExceptionReader> globalExceptionReaders = new CopyOnWriteArrayList<ExceptionReader>();
    private static List<ExceptionReader> exceptionReaders = new CopyOnWriteArrayList<ExceptionReader>();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();
    public static String[] stackTraceFilter = DEFAULT_STACKTRACE_FILTER;

    protected ExceptionHelper() {
    }

    public static <T extends Throwable> T unwrap(T t) {
        if (t instanceof InvocationTargetException) {
            return (T)((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    public static ExceptionReader getExceptionReader(Throwable t) {
        for (ExceptionReader exceptionReader : globalExceptionReaders) {
            if (!exceptionReader.getExceptionType().isInstance(t)) continue;
            return exceptionReader;
        }
        if (!exceptionReaders.isEmpty()) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (ExceptionReader exceptionReader : exceptionReaders) {
                ClassLoader currentCl;
                for (currentCl = tccl; currentCl != null && currentCl != ExceptionHelper.class.getClassLoader() && currentCl != exceptionReader.getClass().getClassLoader(); currentCl = currentCl.getParent()) {
                }
                if (currentCl != exceptionReader.getClass().getClassLoader() || !exceptionReader.getExceptionType().isInstance(t)) continue;
                return exceptionReader;
            }
        }
        return defaultExceptionReader;
    }

    public static MuleException getRootMuleException(Throwable t) {
        Throwable cause = t;
        MuleException exception = null;
        SmallMap<String, Object> muleExceptionInfo = new SmallMap<String, Object>();
        while (cause != null && !(cause instanceof SuppressedMuleException)) {
            if (cause instanceof MuleException) {
                exception = (MuleException)cause;
                muleExceptionInfo.putAll(exception.getInfo());
            }
            Throwable tempCause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
            cause = verbose ? tempCause : ExceptionHelper.sanitize(tempCause);
            if (t != cause) continue;
            break;
        }
        if (exception != null) {
            for (Map.Entry entry : muleExceptionInfo.entrySet()) {
                exception.addInfo((String)entry.getKey(), entry.getValue());
            }
        }
        return exception;
    }

    public static Throwable getNonMuleException(Throwable t) {
        if (!(t instanceof MuleException)) {
            return t;
        }
        Throwable cause = t;
        while (cause != null && t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause)) && cause instanceof MuleException) {
        }
        return cause instanceof MuleException ? null : cause;
    }

    public static Map<String, Object> getExceptionInfo(Throwable t) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Throwable cause = t;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return info;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable cause = t;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
        }
        return verbose ? root : ExceptionHelper.sanitize(root);
    }

    public static String getExceptionStack(Throwable t) {
        MuleException rootMule = ExceptionHelper.getRootMuleException(t);
        StringBuilder buf = new StringBuilder();
        ExceptionReader rootMuleReader = ExceptionHelper.getExceptionReader(rootMule);
        buf.append(rootMuleReader.getMessage(rootMule)).append(" (").append(rootMule.getClass().getName()).append(")").append(System.lineSeparator());
        if (verbose) {
            Throwable root = ExceptionHelper.getRootException(t);
            int processedElements = 0;
            int processedMuleElements = 1;
            for (StackTraceElement stackTraceElement : root.getStackTrace()) {
                if (processedMuleElements > 3) break;
                ++processedElements;
                if (stackTraceElement.getClassName().matches(MULE_PACKAGE_REGEXP)) {
                    ++processedMuleElements;
                }
                buf.append("  ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")").append(System.lineSeparator());
            }
            if (root.getStackTrace().length - processedElements > 0) {
                buf.append("  (").append(root.getStackTrace().length - processedElements).append(" more...)").append(System.lineSeparator());
            }
        }
        return buf.toString();
    }

    private static void initialise() {
        if (initialised) {
            return;
        }
        String stackTraceFilterString = System.getProperty("mule.stacktrace.filter");
        if (stackTraceFilterString != null) {
            stackTraceFilter = stackTraceFilterString.split(",");
        }
        ExceptionHelper.registerGlobalExceptionReader(new NamingExceptionReader());
        initialised = true;
    }

    public static Throwable sanitize(Throwable t) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] trace = t.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        String currentlyMatchedPrefix = null;
        int currentlyMatchedPrefixCount = 0;
        for (StackTraceElement stackTraceElement : trace) {
            Optional<String> matchedPrefix = ExceptionHelper.matchedMuleInternalClassPrefix(stackTraceElement);
            if (!matchedPrefix.isPresent()) {
                if (currentlyMatchedPrefix != null) {
                    newTrace.add(ExceptionHelper.createFilteredStackEntry(currentlyMatchedPrefix, currentlyMatchedPrefixCount));
                    currentlyMatchedPrefix = null;
                    currentlyMatchedPrefixCount = 0;
                }
                newTrace.add(stackTraceElement);
                continue;
            }
            if (currentlyMatchedPrefix != null) {
                if (currentlyMatchedPrefix.equals(matchedPrefix.get())) {
                    ++currentlyMatchedPrefixCount;
                    continue;
                }
                newTrace.add(ExceptionHelper.createFilteredStackEntry(currentlyMatchedPrefix, currentlyMatchedPrefixCount));
            }
            currentlyMatchedPrefix = matchedPrefix.get();
            currentlyMatchedPrefixCount = 1;
        }
        StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
        newTrace.toArray(clean);
        t.setStackTrace(clean);
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            ExceptionHelper.sanitize(cause);
        }
        return t;
    }

    private static StackTraceElement createFilteredStackEntry(String currentlyMatchedPrefix, int currentlyMatchedPrefixCount) {
        return new StackTraceElement(currentlyMatchedPrefix, String.format("* (%d elements filtered from stack; set debug level logging or '-Dmule.verbose.exceptions=true' for everything)", currentlyMatchedPrefixCount), null, -3);
    }

    public static Throwable summarise(Throwable t, int depth) {
        t = ExceptionHelper.sanitize(t);
        StackTraceElement[] trace = t.getStackTrace();
        int newStackDepth = Math.min(trace.length, depth);
        StackTraceElement[] newTrace = new StackTraceElement[newStackDepth];
        System.arraycopy(trace, 0, newTrace, 0, newStackDepth);
        t.setStackTrace(newTrace);
        return t;
    }

    private static Optional<String> matchedMuleInternalClassPrefix(StackTraceElement stackTraceElement) {
        if (stackTraceElement.getLineNumber() == -3) {
            return Optional.empty();
        }
        for (String mulePackage : stackTraceFilter) {
            if (!stackTraceElement.getClassName().startsWith(mulePackage)) continue;
            return Optional.of(mulePackage);
        }
        return Optional.empty();
    }

    public static List<Throwable> getExceptionsAsList(Throwable t) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(4);
        Throwable cause = t;
        while (cause != null && !(cause instanceof SuppressedMuleException)) {
            exceptions.add(cause);
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exceptions;
    }

    public static void registerGlobalExceptionReader(ExceptionReader reader) {
        if (reader.getClass().getClassLoader() != ExceptionHelper.class.getClassLoader()) {
            throw new IllegalArgumentException("Only the Runtime itself may register global readers.");
        }
        globalExceptionReaders.add(reader);
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        for (ExceptionReader exceptionReader : globalExceptionReaders) {
            if (!exceptionReader.getExceptionType().equals(reader.getExceptionType())) continue;
            throw new IllegalArgumentException(String.format("There's a globalExceptionReader already registerd for '%s': %s", reader.getExceptionType(), reader.toString()));
        }
        exceptionReaders.add(reader);
    }

    public static boolean unregisterExceptionReader(ExceptionReader reader) {
        return exceptionReaders.remove(reader);
    }

    static {
        ExceptionHelper.initialise();
    }
}

