/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.MapEntry;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class MapEntryBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String ENTRY_TYPE_KEY_PARAMETER_NAME = "key";
    private static final String ENTRY_TYPE_VALUE_REF_PARAMETER_NAME = "value-ref";

    MapEntryBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(createBeanDefinitionRequest.getComponentModel());
        createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit(objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (!TypeDefinition.MapEntryType.class.isAssignableFrom(type)) {
            return false;
        }
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
        componentModel.setType(type);
        String key = componentModel.getRawParameters().get(ENTRY_TYPE_KEY_PARAMETER_NAME);
        BeanDefinition keyBeanDefinition = this.getConvertibleBeanDefinition(objectTypeVisitor.getMapEntryType().get().getKeyType(), key, componentBuildingDefinition.getKeyTypeConverter());
        Object value = null;
        value = componentModel.getRawParameters().get(ENTRY_TYPE_VALUE_REF_PARAMETER_NAME) != null ? new RuntimeBeanReference(componentModel.getRawParameters().get(ENTRY_TYPE_VALUE_REF_PARAMETER_NAME)) : this.getValue(objectTypeVisitor, componentModel, componentBuildingDefinition);
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MapEntry.class).addConstructorArgValue((Object)keyBeanDefinition).addConstructorArgValue(value).getBeanDefinition();
        componentModel.setBeanDefinition((BeanDefinition)beanDefinition);
        return true;
    }

    private Object getValue(ObjectTypeVisitor objectTypeVisitor, SpringComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        BeanDefinition value;
        Class<?> valueType = objectTypeVisitor.getMapEntryType().get().getValueType();
        if (DslSimpleType.isSimpleType(valueType) || componentModel.getInnerComponents().isEmpty()) {
            value = this.getConvertibleBeanDefinition(objectTypeVisitor.getMapEntryType().get().getValueType(), componentModel.getRawParameters().get("value"), componentBuildingDefinition.getTypeConverter());
        } else if (List.class.isAssignableFrom(objectTypeVisitor.getMapEntryType().get().getValueType())) {
            if (componentModel.getInnerComponents().isEmpty()) {
                String valueParameter = componentModel.getRawParameters().get("value");
                value = this.getConvertibleBeanDefinition(valueType, valueParameter, componentBuildingDefinition.getTypeConverter());
            } else {
                ManagedList managedList = componentModel.getInnerComponents().stream().map(childComponent -> ((SpringComponentModel)childComponent).getBeanDefinition() != null ? ((SpringComponentModel)childComponent).getBeanDefinition() : ((SpringComponentModel)childComponent).getBeanReference()).collect(Collectors.toCollection(ManagedList::new));
                value = BeanDefinitionBuilder.genericBeanDefinition(ObjectTypeVisitor.DEFAULT_COLLECTION_TYPE).addConstructorArgValue((Object)managedList).getBeanDefinition();
            }
        } else {
            SpringComponentModel childComponentModel = (SpringComponentModel)componentModel.getInnerComponents().get(0);
            BeanDefinition beanDefinition = childComponentModel.getBeanDefinition();
            value = beanDefinition != null ? beanDefinition : childComponentModel.getBeanReference();
        }
        return value;
    }
}

