/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.thread.notification;

import org.mule.runtime.core.api.context.thread.notification.ThreadNotificationService;

public final class DefaultThreadNotificationElement
implements ThreadNotificationService.ThreadNotificationElement {
    private String fromThreadType;
    private String toThreadType;
    private long measuredLatency;

    private DefaultThreadNotificationElement(String from, String to, long time) {
        this.fromThreadType = from;
        this.toThreadType = to;
        this.measuredLatency = time;
    }

    @Override
    public long getLatencyTime() {
        return this.measuredLatency;
    }

    @Override
    public String getFromThreadType() {
        return this.fromThreadType;
    }

    @Override
    public String getToThreadType() {
        return this.toThreadType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String fromType;
        private String toType;
        private long startTime;
        private long stopTime;

        public ThreadNotificationService.ThreadNotificationElement build() {
            return new DefaultThreadNotificationElement(this.fromType, this.toType, this.stopTime - this.startTime);
        }

        public Builder fromThread(Thread thread) {
            this.fromType = thread.getThreadGroup().getName();
            this.startTime = System.nanoTime();
            return this;
        }

        public Builder toThread(Thread thread) {
            this.toType = thread.getThreadGroup().getName();
            this.stopTime = System.nanoTime();
            return this;
        }
    }
}

