/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.management.stats.PayloadStatistics;
import org.mule.runtime.core.internal.management.stats.NoOpCursorComponentDecoratorFactory;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsCollection;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsCursorStream;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsInputStream;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsIterator;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsList;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsPagingProvider;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsSet;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

class PayloadStatisticsCursorComponentDecoratorFactory
implements CursorComponentDecoratorFactory {
    private final PayloadStatistics payloadStatistics;

    public PayloadStatisticsCursorComponentDecoratorFactory(PayloadStatistics payloadStatistics) {
        this.payloadStatistics = payloadStatistics;
    }

    @Override
    public void incrementInvocationCount(String correlationId) {
        if (this.payloadStatistics.isEnabled()) {
            this.payloadStatistics.incrementInvocationCount();
        }
    }

    @Override
    public <T> Collection<T> decorateInput(Collection<T> decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            if (decorated instanceof List) {
                return new PayloadStatisticsList((List)decorated, this.payloadStatistics::addInputObjectCount);
            }
            if (decorated instanceof Set) {
                return new PayloadStatisticsSet((Set)decorated, this.payloadStatistics::addInputObjectCount);
            }
            return new PayloadStatisticsCollection<T>(decorated, this.payloadStatistics::addInputObjectCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateInput(decorated, correlationId);
    }

    @Override
    public <T> Iterator<T> decorateInput(Iterator<T> decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            return new PayloadStatisticsIterator<T>(decorated, this.payloadStatistics::addInputObjectCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateInput(decorated, correlationId);
    }

    @Override
    public InputStream decorateInput(InputStream decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            if (decorated instanceof CursorStream) {
                return new PayloadStatisticsCursorStream((CursorStream)decorated, this.payloadStatistics::addInputByteCount);
            }
            return new PayloadStatisticsInputStream(decorated, this.payloadStatistics::addInputByteCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateInput(decorated, correlationId);
    }

    @Override
    public <C, T> PagingProvider<C, T> decorateOutput(PagingProvider<C, T> decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            return new PayloadStatisticsPagingProvider<C, T>(decorated, this.payloadStatistics::addOutputObjectCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateOutput(decorated, correlationId);
    }

    @Override
    public <T> Iterator<T> decorateOutput(Iterator<T> decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            return new PayloadStatisticsIterator<T>(decorated, this.payloadStatistics::addOutputObjectCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateOutput(decorated, correlationId);
    }

    @Override
    public InputStream decorateOutput(InputStream decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            if (decorated instanceof CursorStream) {
                return new PayloadStatisticsCursorStream((CursorStream)decorated, this.payloadStatistics::addOutputByteCount);
            }
            return new PayloadStatisticsInputStream(decorated, this.payloadStatistics::addOutputByteCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateOutput(decorated, correlationId);
    }

    @Override
    public <T> Collection<T> decorateOutputCollection(Collection<T> decorated, String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            this.payloadStatistics.addOutputObjectCount(decorated.size());
            return decorated.stream().map(r -> r instanceof Result ? this.decorateResult((Result)r, correlationId) : r).collect(Collectors.toList());
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateOutputCollection(decorated, correlationId);
    }

    @Override
    public <T> Iterator<T> decorateOutputIterator(Iterator<T> decorated, final String correlationId) {
        if (decorated == null) {
            return decorated;
        }
        if (this.payloadStatistics.isEnabled()) {
            return this.decorateOutput((Iterator<T>)new AbstractIteratorDecorator(decorated){

                public Object next() {
                    Object next = super.next();
                    if (next instanceof Result) {
                        return PayloadStatisticsCursorComponentDecoratorFactory.this.decorateResult((Result)next, correlationId);
                    }
                    return next;
                }
            }, correlationId);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateOutputIterator(decorated, correlationId);
    }

    private Result decorateResult(Result decorated, String correlationId) {
        Object decoratedOutput = this.decorateOutput(decorated.getOutput(), correlationId);
        if (decoratedOutput == decorated.getOutput()) {
            return decorated;
        }
        return decorated.copy().output(decoratedOutput).build();
    }

    private Object decorateOutput(Object decorated, String correlationId) {
        if (decorated instanceof InputStream) {
            return this.decorateOutput((InputStream)decorated, correlationId);
        }
        if (decorated instanceof Iterator) {
            return this.decorateOutput((Iterator)decorated, correlationId);
        }
        return decorated;
    }

    @Override
    public CursorStream decorateInput(CursorStream decorated, String correlationId) {
        if (this.payloadStatistics.isEnabled()) {
            return new PayloadStatisticsCursorStream(decorated, this.payloadStatistics::addInputByteCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateInput(decorated, correlationId);
    }

    @Override
    public CursorStream decorateOutput(CursorStream decorated, String correlationId) {
        if (this.payloadStatistics.isEnabled()) {
            return new PayloadStatisticsCursorStream(decorated, this.payloadStatistics::addOutputByteCount);
        }
        return NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE.decorateInput(decorated, correlationId);
    }

    @Override
    public void computeInputByteCount(byte[] v) {
        this.payloadStatistics.addInputByteCount(v.length);
    }
}

