/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.internal.util.message.ResultToMessageIterator;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

abstract class ResultsToMessageCollection
implements Collection<Message> {
    private final Collection<Object> delegate;
    protected final CursorProviderFactory cursorProviderFactory;
    protected final BaseEventContext eventContext;
    protected final ComponentLocation originatingLocation;
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();

    public ResultsToMessageCollection(Collection<Object> delegate, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        this.delegate = delegate;
        this.cursorProviderFactory = cursorProviderFactory;
        this.eventContext = eventContext;
        this.originatingLocation = originatingLocation;
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean contains = this.delegate.contains(o);
            if (!contains && o instanceof Message) {
                contains = this.delegate.contains(Result.builder((Message)o));
            }
            boolean bl = contains;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return new ResultToMessageIterator(this.delegate.iterator(), this.cursorProviderFactory, this.eventContext, this.originatingLocation);
    }

    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.transformArray(this.delegate.toArray());
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.transformArray(this.delegate.toArray(a));
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private <T> T[] transformArray(T[] array) {
        return Stream.of(array).map(result -> this.toMessage(result, this.cursorProviderFactory, this.eventContext)).toArray(Object[]::new);
    }

    @Override
    public boolean add(Message message) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.add(message);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.readLock.lock();
        try {
            boolean bl = this.delegate.stream().allMatch(this.delegate::contains);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected Collection<?> toResults(Collection<?> messages) {
        return messages.stream().map(o -> {
            if (o instanceof Message) {
                return o;
            }
            return this.toMessage(o, this.cursorProviderFactory, this.eventContext);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean addAll(Collection<? extends Message> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.addAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.writeLock.lock();
        try {
            boolean removed = false;
            for (Object value : c) {
                boolean itemRemoved = this.delegate.remove(c);
                if (!itemRemoved) {
                    itemRemoved = this.delegate.remove(this.toMessage(value, this.cursorProviderFactory, this.eventContext));
                }
                removed = removed || itemRemoved;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super Message> filter) {
        return this.delegate.removeIf((? super E result) -> filter.test(this.toMessage(result, this.cursorProviderFactory, this.eventContext)));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(this.toResults(c));
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean equals(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.equals(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        this.writeLock.lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Spliterator<Message> spliterator() {
        return this.delegate.stream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.eventContext)).collect(Collectors.toList()).spliterator();
    }

    @Override
    public Stream<Message> stream() {
        return this.delegate.stream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.eventContext));
    }

    @Override
    public Stream<Message> parallelStream() {
        return this.delegate.parallelStream().map(result -> this.toMessage(result, this.cursorProviderFactory, this.eventContext));
    }

    @Override
    public void forEach(Consumer<? super Message> action) {
        this.stream().forEach(action);
    }

    protected Message toMessage(Object value, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext) {
        if (value instanceof Message) {
            return (Message)value;
        }
        return MessageUtils.toMessage((Result)value, cursorProviderFactory, eventContext, this.originatingLocation);
    }
}

