/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

final class FilteredCompositeErrorTypeRepository
implements ErrorTypeRepository {
    private final ErrorTypeRepository childErrorTypeRepository;
    private final ErrorTypeRepository parentErrorTypeRepository;
    private final String namespaceFromParent;

    public FilteredCompositeErrorTypeRepository(ErrorTypeRepository childErrorTypeRepository, ErrorTypeRepository parentErrorTypeRepository, String namespaceFromParent) {
        this.childErrorTypeRepository = childErrorTypeRepository;
        this.parentErrorTypeRepository = parentErrorTypeRepository;
        this.namespaceFromParent = namespaceFromParent;
    }

    @Override
    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.childErrorTypeRepository.addErrorType(errorTypeIdentifier, parentErrorType);
    }

    @Override
    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.childErrorTypeRepository.addInternalErrorType(errorTypeIdentifier, parentErrorType);
    }

    @Override
    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        Optional<ErrorType> errorType = this.childErrorTypeRepository.lookupErrorType(errorTypeComponentIdentifier);
        if (!errorType.isPresent() && this.namespaceFromParent.equals(errorTypeComponentIdentifier.getNamespace())) {
            errorType = this.parentErrorTypeRepository.lookupErrorType(errorTypeComponentIdentifier);
        }
        return errorType;
    }

    @Override
    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.childErrorTypeRepository.getErrorType(errorTypeIdentifier);
        if (!errorType.isPresent() && this.namespaceFromParent.equals(errorTypeIdentifier.getNamespace())) {
            errorType = this.parentErrorTypeRepository.getErrorType(errorTypeIdentifier);
        }
        return errorType;
    }

    @Override
    public Collection<String> getErrorNamespaces() {
        return Stream.concat(this.parentErrorTypeRepository.getErrorNamespaces().stream().filter(this.namespaceFromParent::equals), this.childErrorTypeRepository.getErrorNamespaces().stream()).collect(Collectors.toSet());
    }

    @Override
    public ErrorType getAnyErrorType() {
        return this.childErrorTypeRepository.getAnyErrorType();
    }

    @Override
    public ErrorType getSourceErrorType() {
        return this.childErrorTypeRepository.getSourceErrorType();
    }

    @Override
    public ErrorType getSourceResponseErrorType() {
        return this.childErrorTypeRepository.getSourceResponseErrorType();
    }

    @Override
    public ErrorType getCriticalErrorType() {
        return this.childErrorTypeRepository.getCriticalErrorType();
    }
}

