/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.AbstractReturnDelegate;

final class TargetReturnDelegate
extends AbstractReturnDelegate {
    private final ExpressionManager expressionManager;
    private final String target;
    private final CompiledExpression targetValue;
    private final StreamingManager streamingManager;

    TargetReturnDelegate(String target, String targetValue, ComponentModel componentModel, ExpressionManager expressionManager, CursorComponentDecoratorFactory componentDecoratorFactory, CursorProviderFactory cursorProviderFactory, MuleContext muleContext, StreamingManager streamingManager) {
        super(componentModel, componentDecoratorFactory, cursorProviderFactory, muleContext);
        this.expressionManager = expressionManager;
        this.target = target;
        this.targetValue = expressionManager.compile(targetValue, BindingContextUtils.getTargetBindingContext(Message.of("")));
        this.streamingManager = streamingManager;
    }

    @Override
    public CoreEvent asReturnValue(Object value, ExecutionContextAdapter operationContext) {
        try (ExpressionManagerSession session = this.expressionManager.openSession(BindingContextUtils.getTargetBindingContext(this.toMessage(value, operationContext)));){
            CoreEvent event = operationContext.getEvent();
            TypedValue<?> typedValue = session.evaluate(this.targetValue);
            TypedValue managedTypedValue = StreamingUtils.updateTypedValueForStreaming(typedValue, event, this.streamingManager);
            CoreEvent coreEvent = CoreEvent.builder(event).securityContext(operationContext.getSecurityContext()).addVariable(this.target, managedTypedValue).build();
            return coreEvent;
        }
    }
}

