/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.poll;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceWrapper;
import org.mule.runtime.module.extension.internal.runtime.source.poll.DelegateRunnable;
import org.mule.runtime.module.extension.internal.runtime.source.poll.RestartContext;
import org.mule.runtime.module.extension.internal.runtime.source.poll.Restartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSourceWrapper<T, A>
extends SourceWrapper<T, A>
implements Restartable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingSourceWrapper.class);
    private static final String ITEM_RELEASER_CTX_VAR = "itemReleaser";
    private static final String UPDATE_PROCESSED_LOCK = "OSClearing";
    private static final String INFLIGHT_IDS_OS_NAME_SUFFIX = "inflight-ids";
    private static final String POLLING_SOURCE_EXECUTOR_KEY = "Polling source executor";
    private static final String RUNNABLE_KEY = "Runnable";
    private final PollingSource<T, A> delegate;
    private final Scheduler scheduler;
    @Inject
    private LockFactory lockFactory;
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    private SchedulerService schedulerService;
    private ObjectStore<Serializable> watermarkObjectStore;
    private ObjectStore<Serializable> inflightIdsObjectStore;
    private ObjectStore<Serializable> recentlyProcessedIds;
    private ObjectStore<Serializable> idsOnUpdatedWatermark;
    private ComponentLocation componentLocation;
    private String flowName;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private org.mule.runtime.api.scheduler.Scheduler executor;
    private AtomicBoolean restarting = new AtomicBoolean(false);
    private DelegateRunnable delegateRunnable;

    public PollingSourceWrapper(PollingSource<T, A> delegate, Scheduler scheduler) {
        super(delegate);
        this.delegate = delegate;
        this.scheduler = scheduler;
    }

    @Override
    public void onStart(SourceCallback<T, A> sourceCallback) throws MuleException {
        this.delegate.onStart(sourceCallback);
        this.flowName = this.componentLocation.getRootContainerName();
        this.inflightIdsObjectStore = this.objectStoreManager.getOrCreateObjectStore(this.formatKey(INFLIGHT_IDS_OS_NAME_SUFFIX), ObjectStoreSettings.unmanagedTransient());
        this.recentlyProcessedIds = this.objectStoreManager.getOrCreateObjectStore(this.formatKey("recently-processed-ids"), ObjectStoreSettings.unmanagedPersistent());
        this.idsOnUpdatedWatermark = this.objectStoreManager.getOrCreateObjectStore(this.formatKey("ids-on-updated-watermark"), ObjectStoreSettings.unmanagedPersistent());
        this.watermarkObjectStore = this.objectStoreManager.getOrCreateObjectStore(this.formatKey("watermark"), ObjectStoreSettings.unmanagedPersistent());
        this.stopRequested.set(false);
        if (this.restarting.compareAndSet(true, false)) {
            this.poll(sourceCallback);
            this.delegateRunnable.setDelegate(() -> this.poll(sourceCallback));
        } else {
            this.executor = this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withWaitAllowed(true).withName(this.formatKey("executor")));
            this.delegateRunnable = new DelegateRunnable(() -> this.poll(sourceCallback));
            this.scheduler.schedule(this.executor, this.delegateRunnable);
        }
    }

    private String formatKey(String key) {
        return String.format("_pollingSource_%s/%s", this.flowName, key);
    }

    @Override
    public void onStop() {
        this.stopRequested.set(true);
        if (!this.restarting.get()) {
            this.shutdownScheduler();
            this.delegateRunnable = null;
        }
        try {
            this.delegate.onStop();
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Found error while stopping source at location '%s'. %s", this.flowName, t.getMessage()), t);
        }
    }

    @Override
    public void onTerminate(CoreEvent event, Map<String, Object> parameters, SourceCallbackContext context, CompletableCallback<Void> callback) {
        this.releaseOnCallback(context, callback);
    }

    @Override
    public void onBackPressure(CoreEvent event, Map<String, Object> parameters, SourceCallbackContext context, CompletableCallback<Void> callback) {
        this.releaseOnCallback(context, callback);
    }

    private void releaseOnCallback(SourceCallbackContext context, CompletableCallback<Void> callback) {
        this.release(context);
        callback.complete(null);
    }

    private void poll(SourceCallback<T, A> sourceCallback) {
        if (this.isRequestedToStop()) {
            return;
        }
        this.withWatermarkLock(() -> {
            DefaultPollContext pollContext = new DefaultPollContext(sourceCallback, this.getCurrentWatermark(), this.getUpdatedWatermark());
            try {
                this.delegate.poll(pollContext);
                if (!this.isRequestedToStop()) {
                    pollContext.getUpdatedWatermark().ifPresent(w -> this.updateWatermark((Serializable)w, pollContext.getWatermarkComparator()));
                }
            }
            catch (Throwable t) {
                LOGGER.error(String.format("Found exception trying to process item on source at flow '%s'. %s", this.flowName, t.getMessage()), t);
            }
        });
    }

    private int compareWatermarks(Serializable w1, Serializable w2, Comparator comparator) throws IllegalArgumentException {
        if (comparator == null) {
            if (w1 instanceof Serializable && w2 instanceof Serializable) {
                comparator = Comparator.naturalOrder();
            } else {
                throw new IllegalStateException(String.format("Non comparable watermark values [%s, %s] were provided on source at flow '%s'. Use comparable values or set a custom comparator. Watermark not updated.", w1, w2, this.flowName));
            }
        }
        return comparator.compare(w1, w2);
    }

    @Override
    public RestartContext beginRestart() {
        this.restarting.set(true);
        this.delegateRunnable.setDelegate(null);
        return new RestartContext(this.executor, this.delegateRunnable);
    }

    @Override
    public void finishRestart(RestartContext restartContext) {
        this.restarting.set(true);
        this.executor = restartContext.getExecutor();
        this.delegateRunnable = restartContext.getDelegateRunnable();
    }

    private void rejectItem(Result<T, A> result, SourceCallbackContext context) {
        try {
            this.delegate.onRejectedItem(result, context);
        }
        finally {
            this.release(context);
            if (context instanceof SourceCallbackContextAdapter) {
                ((SourceCallbackContextAdapter)context).releaseConnection();
            }
        }
    }

    private void release(SourceCallbackContext context) {
        context.getVariable(ITEM_RELEASER_CTX_VAR).ifPresent(rec$ -> ((ItemReleaser)rec$).release());
    }

    private void withWatermarkLock(CheckedRunnable runnable) {
        Lock lock = this.getWatermarkLock();
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            ConcurrencyUtils.safeUnlock(lock);
        }
    }

    private Lock getWatermarkLock() {
        return this.lockFactory.createLock(this.formatKey("watermark"));
    }

    private void updateWatermark(Serializable value, Comparator comparator) {
        try {
            if (this.watermarkObjectStore.contains("watermark")) {
                Serializable currentValue = this.watermarkObjectStore.retrieve("watermark");
                if (this.compareWatermarks(currentValue, value, comparator) >= 0) {
                    return;
                }
                this.watermarkObjectStore.remove("watermark");
            }
            this.updateRecentlyProcessedIds();
            this.watermarkObjectStore.store("watermark", value);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to update watermark value for message source at location '%s'. %s", this.flowName, e.getMessage())), (Throwable)e);
        }
    }

    private void updateRecentlyProcessedIds() throws ObjectStoreException {
        Lock osClearingLock = this.lockFactory.createLock(UPDATE_PROCESSED_LOCK);
        try {
            osClearingLock.lock();
            List<String> strings = this.idsOnUpdatedWatermark.allKeys();
            this.recentlyProcessedIds.clear();
            strings.forEach(key -> {
                try {
                    this.recentlyProcessedIds.store((String)key, this.idsOnUpdatedWatermark.retrieve((String)key));
                }
                catch (ObjectStoreException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while updating the watermark Ids. Failed to update key '%s' in Watermark-IDs ObjectStore: %s", key, e.getMessage()), (Throwable)e);
                }
            });
            this.idsOnUpdatedWatermark.clear();
        }
        finally {
            ConcurrencyUtils.safeUnlock(osClearingLock);
        }
    }

    private Serializable getCurrentWatermark() {
        try {
            if (this.watermarkObjectStore.contains("watermark")) {
                return this.watermarkObjectStore.retrieve("watermark");
            }
            return null;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to fetch watermark for Message source at location '%s'. %s", this.flowName, e.getMessage())), (Throwable)e);
        }
    }

    private Serializable getUpdatedWatermark() {
        try {
            if (this.watermarkObjectStore.contains("updatedWatermark")) {
                return this.watermarkObjectStore.retrieve("updatedWatermark");
            }
            return null;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to fetch watermark for Message source at location '%s'. %s", this.flowName, e.getMessage())), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireItem(DefaultPollItem pollItem, SourceCallbackContext callbackContext) {
        if (!pollItem.getItemId().isPresent()) {
            return true;
        }
        String id = (String)pollItem.getItemId().get();
        Lock lock = this.lockFactory.createLock(this.flowName + "/" + id);
        if (!lock.tryLock()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Source at flow '{}' is skipping processing of item '{}' because another thread or node already has a mule lock on it", (Object)this.flowName, (Object)id);
            }
            return false;
        }
        try {
            if (this.inflightIdsObjectStore.contains(id)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Source at flow '{}' polled item '{}', but skipping it since it is already being processed in another thread or node", (Object)this.flowName, (Object)id);
                }
                boolean bl = false;
                return bl;
            }
            this.inflightIdsObjectStore.store(id, (Serializable)((Object)id));
            callbackContext.addVariable(ITEM_RELEASER_CTX_VAR, new ItemReleaser(id));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not guarantee idempotency for item '%s' for source at flow '%s'. '%s", id, this.flowName, e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            ConcurrencyUtils.safeUnlock(lock);
        }
    }

    private boolean isRequestedToStop() {
        return this.stopRequested.get() || Thread.currentThread().isInterrupted();
    }

    private void shutdownScheduler() {
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    static /* synthetic */ int access$1000(PollingSourceWrapper x0, Serializable x1, Serializable x2, Comparator x3) throws IllegalArgumentException {
        return x0.compareWatermarks(x1, x2, x3);
    }

    static /* synthetic */ ObjectStore access$1100(PollingSourceWrapper x0) {
        return x0.recentlyProcessedIds;
    }

    private class ItemReleaser {
        private final String id;

        private ItemReleaser(String id) {
            this.id = id;
        }

        private void release() {
            try {
                if (PollingSourceWrapper.this.inflightIdsObjectStore.contains(this.id)) {
                    PollingSourceWrapper.this.inflightIdsObjectStore.remove(this.id);
                }
            }
            catch (ObjectStoreException e) {
                LOGGER.error(String.format("Could not untrack item '%s' in source at flow '%s'. %s", this.id, PollingSourceWrapper.this.flowName, e.getMessage()), (Throwable)e);
            }
        }
    }

    private class DefaultPollItem
    implements PollContext.PollItem<T, A> {
        private final SourceCallbackContext sourceCallbackContext;
        private Result<T, A> result;
        private Serializable watermark;
        private String itemId;

        private DefaultPollItem(SourceCallbackContext sourceCallbackContext) {
            this.sourceCallbackContext = sourceCallbackContext;
        }

        @Override
        public SourceCallbackContext getSourceCallbackContext() {
            return this.sourceCallbackContext;
        }

        @Override
        public PollContext.PollItem<T, A> setResult(Result<T, A> result) {
            Preconditions.checkArgument(result != null, "Cannot set a null Result");
            this.result = result;
            return this;
        }

        @Override
        public PollContext.PollItem<T, A> setWatermark(Serializable watermark) {
            Preconditions.checkArgument(watermark != null, "Cannot set a null watermark");
            this.watermark = watermark;
            return this;
        }

        @Override
        public PollContext.PollItem<T, A> setId(String id) {
            Preconditions.checkArgument(id != null, "Cannot set a null id");
            this.itemId = id;
            return this;
        }

        private Optional<Serializable> getWatermark() {
            return Optional.ofNullable(this.watermark);
        }

        private Optional<String> getItemId() {
            return Optional.ofNullable(this.itemId);
        }

        private Result<T, A> getResult() {
            return this.result;
        }

        private void validate() {
            if (this.result == null) {
                throw new IllegalStateException(String.format("Missing item Result. Source in flow '%s' pushed an item with ID '%s' without configuring its Result", PollingSourceWrapper.this.flowName, this.itemId));
            }
        }

        static /* synthetic */ Optional access$800(DefaultPollItem x0) {
            return x0.getWatermark();
        }
    }

    private class DefaultPollContext
    implements PollContext<T, A> {
        private final SourceCallback<T, A> sourceCallback;
        private Serializable currentWatermark;
        private Serializable updatedWatermark;
        private Comparator<Serializable> watermarkComparator = null;

        private DefaultPollContext(SourceCallback<T, A> sourceCallback, Serializable currentWatermark, Serializable updatedWatermark) {
            this.sourceCallback = sourceCallback;
            this.currentWatermark = currentWatermark;
            this.updatedWatermark = updatedWatermark;
        }

        @Override
        public PollContext.PollItemStatus accept(Consumer<PollContext.PollItem<T, A>> consumer) {
            PollContext.PollItemStatus status;
            SourceCallbackContext callbackContext = this.sourceCallback.createContext();
            DefaultPollItem pollItem = new DefaultPollItem(callbackContext);
            consumer.accept(pollItem);
            pollItem.validate();
            if (PollingSourceWrapper.this.isRequestedToStop()) {
                status = PollContext.PollItemStatus.SOURCE_STOPPING;
            } else if (!PollingSourceWrapper.this.acquireItem(pollItem, callbackContext)) {
                status = PollContext.PollItemStatus.ALREADY_IN_PROCESS;
            } else if (!this.passesWatermark(pollItem)) {
                status = PollContext.PollItemStatus.FILTERED_BY_WATERMARK;
            } else {
                this.sourceCallback.handle(pollItem.getResult(), callbackContext);
                status = PollContext.PollItemStatus.ACCEPTED;
            }
            if (status != PollContext.PollItemStatus.ACCEPTED) {
                PollingSourceWrapper.this.rejectItem(pollItem.getResult(), callbackContext);
            }
            return status;
        }

        @Override
        public boolean isSourceStopping() {
            return PollingSourceWrapper.this.isRequestedToStop();
        }

        @Override
        public Optional<Serializable> getWatermark() {
            return Optional.ofNullable(this.currentWatermark);
        }

        @Override
        public void setWatermarkComparator(Comparator<? extends Serializable> comparator) {
            Preconditions.checkArgument(comparator != null, "Cannot set a null watermark comparator");
            this.watermarkComparator = comparator;
        }

        @Override
        public void onConnectionException(ConnectionException e) {
            this.sourceCallback.onConnectionException(e);
        }

        private Optional<Serializable> getUpdatedWatermark() {
            return Optional.ofNullable(this.updatedWatermark);
        }

        private Comparator<Serializable> getWatermarkComparator() {
            return this.watermarkComparator;
        }

        private void renewUpdatedWatermark(String itemId, Serializable itemWatermark) throws ObjectStoreException {
            PollingSourceWrapper.this.idsOnUpdatedWatermark.clear();
            if (itemId != null) {
                PollingSourceWrapper.this.idsOnUpdatedWatermark.store(itemId, itemWatermark);
            }
            this.setUpdatedWatermark(itemWatermark);
        }

        private void setUpdatedWatermark(Serializable updatedWatermark) {
            try {
                this.updatedWatermark = updatedWatermark;
                if (PollingSourceWrapper.this.watermarkObjectStore.contains("updatedWatermark")) {
                    PollingSourceWrapper.this.watermarkObjectStore.remove("updatedWatermark");
                }
                PollingSourceWrapper.this.watermarkObjectStore.store("updatedWatermark", updatedWatermark);
            }
            catch (ObjectStoreException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while trying to update the updatedWatermark in the the object store"), (Throwable)e);
            }
        }

        private void addToIdsOnUpdatedWatermark(String itemId, Serializable itemWatermark) {
            try {
                if (!PollingSourceWrapper.this.idsOnUpdatedWatermark.contains(itemId)) {
                    PollingSourceWrapper.this.idsOnUpdatedWatermark.store(itemId, itemWatermark);
                }
            }
            catch (ObjectStoreException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while adding an item id to the object store of the items with the highest updated watermark for Item with ID [%s]", itemId), (Throwable)e);
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean passesWatermark(DefaultPollItem pollItem) {
            itemWatermark = DefaultPollItem.access$800(pollItem).orElse(null);
            if (itemWatermark == null) {
                return true;
            }
            itemId = DefaultPollItem.access$900(pollItem).orElse(null);
            accept = true;
            if (this.currentWatermark == null && this.updatedWatermark == null) {
                this.setUpdatedWatermark(itemWatermark);
                DefaultPollItem.access$900(pollItem).ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$passesWatermark$0(java.io.Serializable java.lang.String ), (Ljava/lang/String;)V)((DefaultPollContext)this, (Serializable)itemWatermark));
            } else {
                v0 = compare = this.currentWatermark != null ? PollingSourceWrapper.access$1000(PollingSourceWrapper.this, this.currentWatermark, itemWatermark, this.watermarkComparator) : -1;
                if (compare < 0) {
                    try {
                        if (itemId != null && PollingSourceWrapper.access$1100(PollingSourceWrapper.this).contains(itemId) && PollingSourceWrapper.access$1000(PollingSourceWrapper.this, itemWatermark, previousItemWatermark = PollingSourceWrapper.access$1100(PollingSourceWrapper.this).retrieve(itemId), this.watermarkComparator) <= 0) {
                            accept = false;
                        }
                        v1 = updatedWatermarkCompare = this.updatedWatermark != null ? PollingSourceWrapper.access$1000(PollingSourceWrapper.this, this.updatedWatermark, itemWatermark, this.watermarkComparator) : -1;
                        if (updatedWatermarkCompare == 0) {
                            DefaultPollItem.access$900(pollItem).ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$passesWatermark$1(java.io.Serializable java.lang.String ), (Ljava/lang/String;)V)((DefaultPollContext)this, (Serializable)itemWatermark));
                        }
                        if (updatedWatermarkCompare >= 0) ** GOTO lbl31
                        this.renewUpdatedWatermark(itemId, itemWatermark);
                    }
                    catch (ObjectStoreException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while checking the previous watermark for an item id that was recently processed. Item with ID [%s]", new Object[]{itemId}), (Throwable)e);
                    }
                } else if (compare == 0 && DefaultPollItem.access$900(pollItem).isPresent()) {
                    try {
                        accept = PollingSourceWrapper.access$1100(PollingSourceWrapper.this).contains(itemId) == false;
                    }
                    catch (ObjectStoreException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while checking the existence for Item with ID [%s]", new Object[]{itemId}), (Throwable)e);
                    }
                } else {
                    accept = false;
                }
            }
lbl31:
            // 6 sources

            if (accept) {
                try {
                    if (itemId == null) ** GOTO lbl44
                    if (PollingSourceWrapper.access$1100(PollingSourceWrapper.this).contains(itemId)) {
                        PollingSourceWrapper.access$1100(PollingSourceWrapper.this).remove(itemId);
                    }
                    PollingSourceWrapper.access$1100(PollingSourceWrapper.this).store(itemId, itemWatermark);
                }
                catch (ObjectStoreException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("An error occurred while updating the watermark for Item with ID [%s]", new Object[]{itemId}), (Throwable)e);
                }
            } else if (PollingSourceWrapper.access$1200().isDebugEnabled()) {
                itemId = DefaultPollItem.access$900(pollItem).orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$passesWatermark$2(org.mule.runtime.module.extension.internal.runtime.source.poll.PollingSourceWrapper$DefaultPollItem ), ()Ljava/lang/String;)((DefaultPollItem)pollItem));
                PollingSourceWrapper.access$1200().debug("Source in flow '{}' is skipping item '{}' because it was rejected by the watermark", (Object)PollingSourceWrapper.access$1300(PollingSourceWrapper.this), (Object)itemId);
            }
lbl44:
            // 5 sources

            return accept;
        }

        private static /* synthetic */ String lambda$passesWatermark$2(DefaultPollItem pollItem) {
            return pollItem.getResult().getAttributes().map(Object::toString).orElse("");
        }

        private /* synthetic */ void lambda$passesWatermark$1(Serializable itemWatermark, String id) {
            this.addToIdsOnUpdatedWatermark(id, itemWatermark);
        }

        private /* synthetic */ void lambda$passesWatermark$0(Serializable itemWatermark, String id) {
            this.addToIdsOnUpdatedWatermark(id, itemWatermark);
        }
    }
}

