/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import com.ning.http.client.uri.Uri;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class RedirectUtils {
    public static boolean shouldFollowRedirect(HttpResponse response, HttpRequestOptions options) {
        return RedirectUtils.isRedirected(response.getStatusCode()) && response.getHeaders().containsKey("Location") && options.isFollowsRedirect();
    }

    public static boolean isRedirected(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public static HttpRequest createRedirectRequest(HttpResponse response, HttpRequest request) {
        Uri path = Uri.create((Uri)Uri.create((String)request.getUri().toString()), (String)response.getHeaders().get("Location"));
        return ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(path.toUrl()).method(request.getMethod()).protocol(request.getProtocol()).headers(request.getHeaders())).queryParams(request.getQueryParams()).entity(request.getEntity())).build();
    }
}

