/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.processor;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.internal.config.dsl.XmlSdkConfigurationProvider;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.util.context.Context;

public class ModuleOperationMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor,
ErrorMappingsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleOperationMessageProcessor.class);
    private static final String ORIGINAL_EVENT_KEY = "mule.xmlSdk.originalEvent";
    private final ExtensionManager extensionManager;
    private final List<ParameterModel> allProperties;
    private final Map<String, Pair<Object, MetadataType>> properties;
    private final Map<String, Pair<Object, MetadataType>> parameters;
    private final boolean returnsVoid;
    private final Optional<String> target;
    private final String targetValue;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    private MessageProcessorChain nestedChain;
    private List<Processor> processors;
    private CompiledExpression targetValueExpression;
    private List<ErrorMapping> errorMappings = Collections.emptyList();

    public ModuleOperationMessageProcessor(Map<String, Object> parameters, ExtensionManager extensionManager, ExtensionModel extensionModel, OperationModel operationModel) {
        this.extensionManager = extensionManager;
        this.allProperties = this.getAllProperties(extensionModel);
        this.properties = this.parseParameters(this.getProperties(parameters), this.allProperties);
        this.parameters = this.parseParameters(parameters, operationModel.getAllParameterModels());
        this.returnsVoid = MetadataTypeUtils.isVoid(operationModel.getOutput().getType());
        this.target = parameters.containsKey("target") ? Optional.of((String)parameters.remove("target")) : Optional.empty();
        this.targetValue = (String)parameters.remove("targetValue");
    }

    public Map<String, String> getProperties(Map<String, Object> parameters) {
        if (parameters.containsKey("config-ref")) {
            return this.createPropertiesFromConfigName((String)parameters.get("config-ref"));
        }
        return Collections.emptyMap();
    }

    private Map<String, String> createPropertiesFromConfigName(String configName) {
        return this.extensionManager.getConfigurationProvider(configName).filter(cp -> cp instanceof XmlSdkConfigurationProvider).map(cp -> ((XmlSdkConfigurationProvider)cp).getParameters()).orElse(Collections.emptyMap());
    }

    private List<ParameterModel> getAllProperties(ExtensionModel extensionModel) {
        ArrayList<ParameterModel> result = new ArrayList<ParameterModel>();
        extensionModel.getConfigurationModel("config").ifPresent(configurationModel -> {
            result.addAll(configurationModel.getAllParameterModels());
            configurationModel.getConnectionProviderModel("connection").ifPresent(connectionProviderModel -> result.addAll(connectionProviderModel.getAllParameterModels()));
        });
        return result;
    }

    private Map<String, Pair<Object, MetadataType>> parseParameters(Map<String, ?> parameters, List<ParameterModel> parameterModels) {
        HashMap<String, Pair<Object, MetadataType>> result = new HashMap<String, Pair<Object, MetadataType>>();
        for (ParameterModel parameterModel : parameterModels) {
            String parameterName = parameterModel.getName();
            if (parameterName.equals("target") || parameterName.equals("targetValue")) continue;
            if (parameters.containsKey(parameterName)) {
                Object xmlValue = parameters.get(parameterName);
                if (xmlValue instanceof String) {
                    result.put(parameterName, new Pair<String, MetadataType>(((String)xmlValue).trim(), parameterModel.getType()));
                    continue;
                }
                result.put(parameterName, new Pair(xmlValue, parameterModel.getType()));
                continue;
            }
            if (parameterModel.getDefaultValue() == null || !ParameterRole.PRIMARY_CONTENT.equals((Object)parameterModel.getRole()) && !ParameterRole.CONTENT.equals((Object)parameterModel.getRole())) continue;
            result.put(parameterName, new Pair<String, MetadataType>((String)parameterModel.getDefaultValue(), parameterModel.getType()));
        }
        return result;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        String localStrategyCtxKey = "mule.xmlSdk." + this.getLocation().getLocation() + ".reactor.onNextError.localStrategy";
        return Flux.from(publisher).map(this::createEventWithParameters).subscriberContext(ctx -> ctx.getOrEmpty((Object)localStrategyCtxKey).map(localErrorStr -> ctx.put((Object)"reactor.onNextError.localStrategy", localErrorStr)).orElse((Context)ctx)).compose(eventPub -> MessageProcessors.applyWithChildContext((Publisher<CoreEvent>)eventPub, p -> Flux.from((Publisher)p).doOnNext(this::pushFlowStackEntry).compose((Function)this.nestedChain).doOnNext(event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop()), Optional.ofNullable(this.getLocation()), this.errorHandler())).subscriberContext(ctx -> ctx.getOrEmpty((Object)"reactor.onNextError.localStrategy").map(onNextErrorStr -> ctx.put((Object)localStrategyCtxKey, onNextErrorStr)).orElse((Context)ctx)).map(eventResult -> this.processResult((CoreEvent)this.getInternalParameter(ORIGINAL_EVENT_KEY, (CoreEvent)eventResult), (CoreEvent)eventResult));
    }

    private void pushFlowStackEntry(CoreEvent event) {
        DefaultFlowCallStack flowCallStack = (DefaultFlowCallStack)event.getFlowCallStack();
        flowCallStack.push(this.createFlowStackEntry(flowCallStack.peek()));
    }

    private FlowStackElement createFlowStackEntry(FlowStackElement top) {
        ComponentIdentifier identifier = this.getIdentifier();
        if (identifier.getNamespace() == null || "tns".equals(identifier.getNamespace())) {
            String[] peekedWithNamespace = top.getFlowName().split("\\:");
            String peekedNamespace = peekedWithNamespace[0];
            return new FlowStackElement(peekedNamespace + ":" + identifier.getName(), null);
        }
        return new FlowStackElement(identifier.getNamespace() + ":" + identifier.getName(), null);
    }

    private BaseExceptionHandler errorHandler() {
        return new BaseExceptionHandler(){

            @Override
            protected void onError(Exception exception) {
                MessagingException me = (MessagingException)exception;
                CoreEvent event = me.getEvent();
                EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo(event, me, null);
                for (ExceptionContextProvider exceptionContextProvider : ModuleOperationMessageProcessor.this.exceptionContextProviders) {
                    exceptionContextProvider.putContextInfo(me.getExceptionInfo(), notificationInfo, ModuleOperationMessageProcessor.this);
                }
                ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
                this.handleSubChainException(me, (CoreEvent)ModuleOperationMessageProcessor.this.getInternalParameter(ModuleOperationMessageProcessor.ORIGINAL_EVENT_KEY, event, ((BaseEventContext)event.getContext()).getParentContext().get()));
            }

            private void handleSubChainException(MessagingException messagingException, CoreEvent originalRequest) {
                CoreEvent.Builder builder = CoreEvent.builder(messagingException.getEvent().getContext(), originalRequest).error(messagingException.getEvent().getError().get());
                List<ErrorMapping> errorMappings = ModuleOperationMessageProcessor.this.getErrorMappings();
                if (!errorMappings.isEmpty()) {
                    Error error = messagingException.getEvent().getError().get();
                    ErrorType errorType = error.getErrorType();
                    ErrorType resolvedType = errorMappings.stream().filter(m -> m.match(errorType)).findFirst().map(ErrorMapping::getTarget).orElse(errorType);
                    if (!resolvedType.equals(errorType)) {
                        builder.error(ErrorBuilder.builder(error).errorType(resolvedType).build());
                    }
                }
                messagingException.setProcessedEvent(builder.build());
            }

            public String toString() {
                return ModuleOperationMessageProcessor.class.getSimpleName() + ".errorHandler @ " + ModuleOperationMessageProcessor.this.getLocation().getLocation();
            }
        };
    }

    private String getParameterId(String keyPrefix, CoreEvent event) {
        return this.getParameterId(keyPrefix, event.getContext());
    }

    private String getParameterId(String keyPrefix, EventContext context) {
        return keyPrefix + context.getId();
    }

    private <T> T getInternalParameter(String keyPrefix, CoreEvent event) {
        return ((InternalEvent)event).getInternalParameter(this.getParameterId(keyPrefix, event));
    }

    private <T> T getInternalParameter(String keyPrefix, CoreEvent event, EventContext context) {
        return ((InternalEvent)event).getInternalParameter(this.getParameterId(keyPrefix, context));
    }

    private CoreEvent processResult(CoreEvent originalEvent, CoreEvent chainEvent) {
        if (!this.returnsVoid) {
            originalEvent = this.createNewEventFromJustMessage(originalEvent, chainEvent);
        }
        return originalEvent;
    }

    private CoreEvent createNewEventFromJustMessage(CoreEvent request, CoreEvent response) {
        CoreEvent.Builder builder = CoreEvent.builder(request);
        if (this.target.isPresent()) {
            try (ExpressionManagerSession session = this.expressionManager.openSession(BindingContextUtils.getTargetBindingContext(response.getMessage()));){
                builder.addVariable(this.target.get(), session.evaluate(this.targetValueExpression));
            }
        } else {
            builder.message(InternalMessage.builder(response.getMessage()).build());
        }
        return builder.build();
    }

    private CoreEvent createEventWithParameters(CoreEvent event) {
        InternalEvent.Builder builder = InternalEvent.builder(event.getContext());
        builder.message(InternalMessage.builder().nullValue().build());
        Map<String, Pair<Object, MetadataType>> resolvedProperties = this.properties.isEmpty() && event.getVariables().containsKey("config-ref") ? this.parseParameters(this.createPropertiesFromConfigName((String)event.getVariables().get("config-ref").getValue()), this.allProperties) : this.properties;
        this.addVariables(event, builder, resolvedProperties);
        this.addVariables(event, builder, this.parameters);
        builder.internalParameters(((InternalEvent)event).getInternalParameters());
        builder.addInternalParameter(this.getParameterId(ORIGINAL_EVENT_KEY, event), event);
        builder.securityContext(event.getSecurityContext());
        InternalEvent newEvent = builder.build();
        newEvent.setSourcePolicyContext(((InternalEvent)event).getSourcePolicyContext());
        return newEvent;
    }

    private void addVariables(CoreEvent event, CoreEvent.Builder builder, Map<String, Pair<Object, MetadataType>> unevaluatedMap) {
        unevaluatedMap.entrySet().stream().forEach(entry -> {
            boolean isExpression = this.expressionManager.isExpression(((Pair)entry.getValue()).getFirst().toString());
            if (isExpression) {
                TypedValue<?> evaluatedValue = this.getEvaluatedValue(event, ((Pair)entry.getValue()).getFirst(), (MetadataType)((Pair)entry.getValue()).getSecond());
                builder.addVariable((String)entry.getKey(), evaluatedValue);
            } else {
                builder.addVariable((String)entry.getKey(), ((Pair)entry.getValue()).getFirst());
            }
        });
    }

    private TypedValue<?> getEvaluatedValue(CoreEvent event, Object value, MetadataType metadataType) {
        TypedValue evaluatedResult;
        Processor head = this.nestedChain.getMessageProcessors().get(0);
        ComponentLocation headLocation = ((Component)((Object)head)).getLocation();
        if (MetadataFormat.JAVA.equals(metadataType.getMetadataFormat())) {
            evaluatedResult = this.expressionManager.evaluate(value.toString(), event, headLocation);
        } else {
            String mediaType = metadataType.getMetadataFormat().getValidMimeTypes().iterator().next();
            DataType expectedOutputType = DataType.builder().type(String.class).mediaType(mediaType).charset(StandardCharsets.UTF_8).build();
            evaluatedResult = this.expressionManager.evaluate(value.toString(), expectedOutputType, BindingContextUtils.NULL_BINDING_CONTEXT, event, headLocation, false);
        }
        return evaluatedResult;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public void initialise() throws InitialisationException {
        Optional<ProcessingStrategy> processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initializing {} {} with processing strategy {}...", new Object[]{this.getClass().getSimpleName(), this.getLocation().getLocation(), processingStrategy});
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(processingStrategy, this.processors);
        super.initialise();
        if (this.targetValue != null) {
            this.targetValueExpression = ExpressionLanguageUtils.compile(this.targetValue, this.expressionManager);
        }
    }

    @Override
    public void dispose() {
        LOGGER.debug("Disposing {} {}...", (Object)this.getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        super.dispose();
    }

    @Override
    public void start() throws MuleException {
        LOGGER.debug("Starting {} {}...", (Object)this.getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LOGGER.debug("Stopping {} {}...", (Object)this.getClass().getSimpleName(), (Object)this.getLocation().getLocation());
        super.stop();
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    @Override
    public List<ErrorMapping> getErrorMappings() {
        return this.errorMappings;
    }

    @Override
    public void setAnnotations(Map<QName, Object> newAnnotations) {
        super.setAnnotations(newAnnotations);
        List list = (List)this.getAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS);
        this.errorMappings = list != null ? list : Collections.emptyList();
    }
}

