/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultCollection;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultIterator;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private boolean returnsListOfMessages = false;
    private final CursorComponentDecoratorFactory componentDecoratorFactory;
    private final CursorProviderFactory cursorProviderFactory;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();
    private final Charset defaultEncoding;

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorComponentDecoratorFactory componentDecoratorFactory, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)((Object)componentModel);
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.muleContext = muleContext;
        this.componentDecoratorFactory = componentDecoratorFactory;
        this.cursorProviderFactory = cursorProviderFactory;
        this.defaultEncoding = SystemUtils.getDefaultEncoding(muleContext);
        this.defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType(componentModel);
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        if (value instanceof Event) {
            return ((Event)((Object)value)).getMessage();
        }
        Map<String, Object> params = operationContext.getParameters();
        MediaType contextMimeTypeParam = this.getContextMimeType(params);
        Charset contextEncodingParam = this.getContextEncoding(params);
        MediaType mediaType = this.resolveMediaType(value, contextMimeTypeParam, contextEncodingParam);
        CoreEvent event = operationContext.getEvent();
        ComponentLocation originatingLocation = operationContext.getComponent().getLocation();
        if (value instanceof Result) {
            ConnectionHandler connectionHandler;
            Result resultValue = (Result)((Object)value);
            if (resultValue.getOutput() instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
                resultValue = resultValue.copy().output(this.componentDecoratorFactory.decorateOutput((InputStream)((Object)new ConnectedInputStreamWrapper((InputStream)resultValue.getOutput(), connectionHandler, this.getDecrementActiveComponentTask(operationContext))), event.getCorrelationId())).build();
            }
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage(resultValue, mediaType, this.cursorProviderFactory, event, this.returnHandler.getDataType(), originatingLocation) : MessageUtils.toMessage(resultValue, mediaType, this.cursorProviderFactory, event, originatingLocation);
        }
        PayloadMediaTypeResolver payloadMediaTypeResolver = new PayloadMediaTypeResolver(this.defaultEncoding, this.defaultMediaType, contextEncodingParam, contextMimeTypeParam);
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = this.toLazyMessageCollection((Collection)((Object)value), operationContext, this.cursorProviderFactory, event);
            value = MessageUtils.toMessageCollection(new MediaTypeDecoratedResultCollection(this.componentDecoratorFactory.decorateOutputCollection((Collection)((Object)value), event.getCorrelationId()), payloadMediaTypeResolver), this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
        } else if (value instanceof Iterator) {
            value = this.returnsListOfMessages ? MessageUtils.toMessageIterator(new MediaTypeDecoratedResultIterator(this.componentDecoratorFactory.decorateOutputIterator((Iterator)value, event.getCorrelationId()), payloadMediaTypeResolver), this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation) : this.componentDecoratorFactory.decorateOutput((Iterator)value, event.getCorrelationId());
        }
        value = this.streamingContent(value, operationContext, this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation, event.getCorrelationId());
        Message.Builder messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)((Object)value), Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    private Collection<Object> toLazyMessageCollection(Collection<Result> values, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        ArrayList<Object> lazyMessageCollection = new ArrayList<Object>();
        values.forEach(value -> {
            ConnectionHandler connectionHandler;
            if (value.getOutput() instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
                value = value.copy().output(StreamingUtils.streamingContent((Object)new ConnectedInputStreamWrapper(this.componentDecoratorFactory.decorateOutput((InputStream)value.getOutput(), event.getCorrelationId()), connectionHandler, this.getDecrementActiveComponentTask(operationContext)), cursorProviderFactory, event)).build();
            }
            lazyMessageCollection.add(value);
        });
        return lazyMessageCollection;
    }

    private MediaType getContextMimeType(Map<String, Object> params) {
        String mimeType = (String)params.get("outputMimeType");
        return mimeType != null ? MediaType.parseDefinedInApp(mimeType) : null;
    }

    private Charset getContextEncoding(Map<String, Object> params) {
        String encoding = (String)params.get("outputEncoding");
        return encoding != null ? MediaTypeUtils.parseCharset(encoding) : null;
    }

    private Object streamingContent(Object value, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation, String correlationId) {
        ConnectionHandler connectionHandler;
        if (value instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
            value = this.componentDecoratorFactory.decorateOutput((InputStream)((Object)new ConnectedInputStreamWrapper((InputStream)value, connectionHandler, this.getDecrementActiveComponentTask(operationContext))), correlationId);
        }
        return StreamingUtils.streamingContent(value, cursorProviderFactory, eventContext, originatingLocation);
    }

    protected MediaType resolveMediaType(Object value, MediaType contextMimeType, Charset contextEncoding) {
        if (contextEncoding == null) {
            contextEncoding = this.defaultEncoding;
        }
        if (contextMimeType == null) {
            Optional<MediaType> optionalMediaType;
            MediaType mediaType = this.defaultMediaType;
            if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = optionalMediaType.get()).getCharset().isPresent()) {
                contextEncoding = mediaType.getCharset().orElse(contextEncoding);
            }
            contextMimeType = mediaType;
        }
        return contextMimeType.withCharset(contextEncoding);
    }

    private Runnable getDecrementActiveComponentTask(ExecutionContextAdapter executionContext) {
        MutableConfigurationStats mutableStats = MuleExtensionUtils.getMutableConfigurationStats(executionContext);
        return mutableStats != null ? mutableStats::discountActiveComponent : null;
    }

    protected class ConnectedInputStreamWrapper
    extends ProxyInputStream {
        private final ConnectionHandler<?> connectionHandler;
        private final Runnable onClose;
        private final AtomicBoolean alreadyClosed;

        private ConnectedInputStreamWrapper(InputStream delegate, ConnectionHandler<?> connectionHandler, Runnable onClose) {
            super(delegate);
            this.alreadyClosed = new AtomicBoolean(false);
            this.connectionHandler = connectionHandler;
            this.onClose = onClose;
        }

        protected void afterRead(int n) throws IOException {
            if (n == -1) {
                this.close();
            }
        }

        public void close() throws IOException {
            try {
                super.close();
                this.in = new ClosedInputStream();
            }
            finally {
                try {
                    this.connectionHandler.release();
                }
                finally {
                    if (this.onClose != null && this.alreadyClosed.compareAndSet(false, true)) {
                        this.onClose.run();
                    }
                }
            }
        }
    }
}

