/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal.authorizationcode;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationRequestUrlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationRequestUrlBuilder.class);
    private static final String ADDED_PARAMETER_TEMPLATE = "&%s=";
    private String authorizationUrl;
    private String redirectUrl;
    private String clientId;
    private String scope;
    private String clientSecret;
    private Map<String, String> customParameters = new HashMap<String, String>();
    private String state;
    private Charset encoding;

    public AuthorizationRequestUrlBuilder setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public AuthorizationRequestUrlBuilder setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public AuthorizationRequestUrlBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public AuthorizationRequestUrlBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public AuthorizationRequestUrlBuilder setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public AuthorizationRequestUrlBuilder setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
        return this;
    }

    public AuthorizationRequestUrlBuilder setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public String buildUrl() {
        Preconditions.checkArgument(!StringUtils.isBlank(this.clientId), "clientId cannot be blank");
        Preconditions.checkArgument(!StringUtils.isBlank(this.clientSecret), "clientSecret cannot be blank");
        Preconditions.checkArgument(!StringUtils.isBlank(this.authorizationUrl), "authorizationUrl cannot be blank");
        Preconditions.checkArgument(this.customParameters != null, "customParameters cannot be null");
        return this.buildAuthorizeUrl();
    }

    private final String buildAuthorizeUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.authorizationUrl);
        urlBuilder.append("?").append("response_type=code&").append("client_id=").append(this.clientId);
        try {
            if (!StringUtils.isBlank(this.scope)) {
                urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "scope")).append(URLEncoder.encode(this.scope, this.encoding.name()));
            }
            if (!StringUtils.isBlank(this.state)) {
                urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "state")).append(URLEncoder.encode(this.state, this.encoding.name()));
            }
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                urlBuilder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), this.encoding.name()));
            }
            urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "redirect_uri")).append(URLEncoder.encode(this.redirectUrl, this.encoding.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authorization URL has been generated as follows: " + urlBuilder);
        }
        return urlBuilder.toString();
    }

    public AuthorizationRequestUrlBuilder setState(String state) {
        this.state = state;
        return this;
    }
}

