/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.config.internal.dsl.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;

class MetadataTypeModelAdapter
implements ParameterizedModel {
    private final MetadataType type;
    private final MetadataType stringType;

    static Optional<MetadataTypeModelAdapter> createMetadataTypeModelAdapterWithSterotype(MetadataType type, ExtensionModelHelper extensionModelHelper) {
        return type.getAnnotation(StereotypeTypeAnnotation.class).flatMap(sta -> sta.getAllowedStereotypes().stream().findFirst()).map(st -> new MetadataTypeModelAdapterWithStereotype(type, (StereotypeModel)st, extensionModelHelper));
    }

    static MetadataTypeModelAdapter createParameterizedTypeModelAdapter(MetadataType type, ExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeModelAdapter(type, extensionModelHelper);
    }

    private MetadataTypeModelAdapter(MetadataType type, ExtensionModelHelper extensionModelHelper) {
        this.type = type;
        this.stringType = extensionModelHelper.findMetadataType(String.class).orElse(null);
    }

    @Override
    public String getName() {
        return MetadataTypeUtils.getTypeId(this.type).orElse(this.type.toString());
    }

    @Override
    public String getDescription() {
        return "MetadataTypeModelAdapter for " + MetadataTypeUtils.getTypeId(this.type).orElse(this.type.toString());
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        if (this.type instanceof ObjectType) {
            return Collections.singletonList(new ObjectTypeAsParameterGroupAdapter((ObjectType)this.type, this.stringType));
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "MetadataTypeModelAdapter{" + this.type.toString() + "}";
    }

    private static class ObjectFieldTypeAsParameterModelAdapter
    implements ParameterModel {
        private final ObjectFieldType wrappedFieldType;
        private final LayoutModel layoutModel;

        public ObjectFieldTypeAsParameterModelAdapter(ObjectFieldType wrappedFieldType) {
            this.wrappedFieldType = wrappedFieldType;
            Optional<LayoutTypeAnnotation> optionalLayoutTypeAnnotation = this.wrappedFieldType.getAnnotation(LayoutTypeAnnotation.class);
            if (optionalLayoutTypeAnnotation.isPresent()) {
                LayoutTypeAnnotation layoutTypeAnnotation = optionalLayoutTypeAnnotation.get();
                LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
                if (layoutTypeAnnotation.isText()) {
                    layoutModelBuilder.asText();
                }
                if (layoutTypeAnnotation.isPassword()) {
                    layoutModelBuilder.asPassword();
                }
                if (layoutTypeAnnotation.isQuery()) {
                    layoutModelBuilder.asQuery();
                }
                this.layoutModel = layoutModelBuilder.build();
            } else {
                this.layoutModel = null;
            }
        }

        @Override
        public String getName() {
            return this.wrappedFieldType.getKey().getName().getLocalPart();
        }

        @Override
        public String getDescription() {
            return this.wrappedFieldType.getKey().getDescription().orElse(null);
        }

        @Override
        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return Optional.empty();
        }

        @Override
        public Set<ModelProperty> getModelProperties() {
            return Collections.emptySet();
        }

        @Override
        public MetadataType getType() {
            return this.wrappedFieldType.getValue();
        }

        @Override
        public boolean hasDynamicType() {
            return false;
        }

        @Override
        public Optional<DisplayModel> getDisplayModel() {
            return Optional.empty();
        }

        @Override
        public Optional<DeprecationModel> getDeprecationModel() {
            return Optional.empty();
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isOverrideFromConfig() {
            return false;
        }

        @Override
        public ExpressionSupport getExpressionSupport() {
            return this.wrappedFieldType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(null);
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public ParameterDslConfiguration getDslConfiguration() {
            return null;
        }

        @Override
        public ParameterRole getRole() {
            return ParameterRole.BEHAVIOUR;
        }

        @Override
        public Optional<LayoutModel> getLayoutModel() {
            return Optional.ofNullable(this.layoutModel);
        }

        @Override
        public List<StereotypeModel> getAllowedStereotypes() {
            return this.wrappedFieldType.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElseGet(() -> this.wrappedFieldType.getValue().getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()));
        }

        @Override
        public Optional<ValueProviderModel> getValueProviderModel() {
            return Optional.empty();
        }

        @Override
        public boolean isComponentId() {
            return this.getName().equals("name");
        }

        public String toString() {
            return "ObjectFieldTypeAsParameterModelAdapter{" + this.wrappedFieldType.toString() + "}";
        }
    }

    private static class ObjectTypeAsParameterGroupAdapter
    implements ParameterGroupModel {
        private final ObjectType adaptedType;
        private final Map<String, ParameterModel> parameterModelsByName;
        private final List<ParameterModel> parameterModels;

        public ObjectTypeAsParameterGroupAdapter(ObjectType adaptedType, MetadataType stringType) {
            this.adaptedType = adaptedType;
            List tempParameterModels = adaptedType.getFields().stream().map(ObjectFieldTypeAsParameterModelAdapter::new).collect(Collectors.toList());
            this.parameterModelsByName = tempParameterModels.stream().collect(Collectors.toMap(NamedObject::getName, Function.identity()));
            if (!this.parameterModelsByName.containsKey("name")) {
                ImmutableParameterModel nameParam = new ImmutableParameterModel("name", "The name of this object in the DSL", stringType, false, true, false, true, ExpressionSupport.NOT_SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                this.parameterModelsByName.put("name", nameParam);
                tempParameterModels.add(nameParam);
            }
            this.parameterModels = Collections.unmodifiableList(tempParameterModels);
        }

        @Override
        public List<ParameterModel> getParameterModels() {
            return this.parameterModels;
        }

        @Override
        public Optional<ParameterModel> getParameter(String name) {
            return Optional.ofNullable(this.parameterModelsByName.get(name));
        }

        @Override
        public String getName() {
            return "General";
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public Optional<DisplayModel> getDisplayModel() {
            return Optional.empty();
        }

        @Override
        public Optional<LayoutModel> getLayoutModel() {
            return Optional.empty();
        }

        @Override
        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return Optional.empty();
        }

        @Override
        public Set<ModelProperty> getModelProperties() {
            return Collections.emptySet();
        }

        @Override
        public List<ExclusiveParametersModel> getExclusiveParametersModels() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShowInDsl() {
            return false;
        }

        public String toString() {
            return "ObjectTypeAsParameterGroupAdapter{" + this.adaptedType.toString() + "}";
        }
    }

    private static class MetadataTypeModelAdapterWithStereotype
    extends MetadataTypeModelAdapter
    implements HasStereotypeModel {
        private final StereotypeModel stereotype;

        private MetadataTypeModelAdapterWithStereotype(MetadataType type, StereotypeModel stereotype, ExtensionModelHelper extensionModelHelper) {
            super(type, extensionModelHelper);
            this.stereotype = stereotype;
        }

        @Override
        public StereotypeModel getStereotype() {
            return this.stereotype;
        }
    }
}

