/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingService;
import org.mule.runtime.core.internal.config.DefaultFeatureFlaggingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeatureFlaggingServiceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFlaggingServiceBuilder.class);
    private MuleContext muleContext;
    private FeatureContext featureContext;
    private String artifactName = "";
    private final Map<Feature, Predicate<FeatureContext>> featureContextFlags = new HashMap<Feature, Predicate<FeatureContext>>();
    private final Map<Feature, Predicate<MuleContext>> muleContextFlags = new HashMap<Feature, Predicate<MuleContext>>();

    public FeatureFlaggingServiceBuilder withContext(MuleContext muleContext) {
        if (this.artifactName.isEmpty()) {
            this.artifactName = muleContext.getId();
        }
        this.muleContext = muleContext;
        return this;
    }

    public FeatureFlaggingServiceBuilder withContext(FeatureContext featureContext) {
        this.artifactName = featureContext.getArtifactName();
        this.featureContext = featureContext;
        return this;
    }

    public FeatureFlaggingServiceBuilder withFeatureContextFlags(Map<Feature, Predicate<FeatureContext>> configurations) {
        this.featureContextFlags.putAll(configurations);
        return this;
    }

    public FeatureFlaggingServiceBuilder withMuleContextFlags(Map<Feature, Predicate<MuleContext>> configurations) {
        this.muleContextFlags.putAll(configurations);
        return this;
    }

    public FeatureFlaggingService build() {
        HashMap<Feature, Boolean> features = new HashMap<Feature, Boolean>();
        LOGGER.debug("Configuring feature flags...");
        if (this.muleContext != null) {
            this.muleContextFlags.forEach((feature, artifactDescriptorPredicate) -> features.put((Feature)feature, this.isFeatureFlagEnabled((Feature)feature, (Object)this.muleContext, (Predicate)artifactDescriptorPredicate)));
        }
        if (this.featureContext != null) {
            this.featureContextFlags.forEach((feature, artifactDescriptorPredicate) -> features.put((Feature)feature, this.isFeatureFlagEnabled((Feature)feature, (Object)this.featureContext, (Predicate)artifactDescriptorPredicate)));
        }
        return new DefaultFeatureFlaggingService(features);
    }

    private <T> boolean isFeatureFlagEnabled(Feature feature, T featureContext, Predicate<T> featurePredicate) {
        boolean enabled;
        Optional<String> systemPropertyName = feature.getOverridingSystemPropertyName();
        if (systemPropertyName.isPresent() && System.getProperty(systemPropertyName.get()) != null) {
            enabled = Boolean.getBoolean(systemPropertyName.get());
            LOGGER.debug("Setting feature {} = {} for artifact [{}] because of System Property '{}'", new Object[]{feature, enabled, this.artifactName, systemPropertyName});
        } else {
            enabled = featurePredicate.test(featureContext);
            LOGGER.debug("Setting feature {} = {} for artifact [{}]", new Object[]{feature, enabled, this.artifactName});
        }
        return enabled;
    }
}

