/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.thread.notification;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.context.thread.notification.ThreadNotificationService;
import org.mule.runtime.core.internal.context.thread.notification.DefaultThreadNotificationElement;

public class ThreadNotificationLogger {
    public static final String THREAD_NOTIFICATION_LOGGER_CONTEXT_KEY = "mule.nb.ThreadNotificationLogger";
    private Map<String, DefaultThreadNotificationElement.Builder> threadNotificationBuilders = new ConcurrentHashMap<String, DefaultThreadNotificationElement.Builder>();
    private ThreadNotificationService threadNotificationService;
    private ThreadLocal<Boolean> sameThread = new ThreadLocal();
    private boolean isThreadLoggingEnabled;

    public ThreadNotificationLogger(ThreadNotificationService threadNotificationService, boolean isThreadLoggingEnabled) {
        this.threadNotificationService = threadNotificationService;
        this.sameThread.set(false);
        this.isThreadLoggingEnabled = isThreadLoggingEnabled;
    }

    public void setStartingThread(String eventId) {
        this.setStartingThread(eventId, false);
    }

    public void setStartingThread(String eventId, boolean avoidIfSet) {
        if (!this.isThreadLoggingEnabled) {
            return;
        }
        if (avoidIfSet && this.threadNotificationBuilders.containsKey(eventId)) {
            return;
        }
        this.sameThread.set(true);
        DefaultThreadNotificationElement.Builder builder = new DefaultThreadNotificationElement.Builder();
        builder.fromThread(Thread.currentThread());
        this.threadNotificationBuilders.put(eventId, builder);
    }

    public void setFinishThread(String eventId) {
        if (!this.isThreadLoggingEnabled) {
            return;
        }
        if (this.sameThread.get() != null && this.sameThread.get().booleanValue()) {
            this.sameThread.set(false);
            return;
        }
        DefaultThreadNotificationElement.Builder builder = this.threadNotificationBuilders.remove(eventId);
        builder.toThread(Thread.currentThread());
        this.threadNotificationService.addThreadNotificationElement(builder.build());
    }
}

