/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.mediatype;

import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResult;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class PayloadMediaTypeResolver {
    private Charset defaultEncoding;
    private MediaType defaultMediaType;
    private Charset encoding;
    private MediaType mimeType;
    private MediaType resolvedMimeType;

    public PayloadMediaTypeResolver(Charset defaultEncoding, MediaType defaultMediaType, Charset encoding, MediaType mimeType) {
        this.defaultEncoding = defaultEncoding;
        this.defaultMediaType = defaultMediaType;
        this.encoding = encoding;
        this.mimeType = mimeType;
        if (mimeType != null && encoding != null) {
            this.resolvedMimeType = mimeType.withCharset(encoding);
        }
    }

    public Result resolve(Result result) {
        return new MediaTypeDecoratedResult(result, this.resolveMediaType(result));
    }

    private MediaType resolveMediaType(Result result) {
        if (this.resolvedMimeType != null) {
            return this.resolvedMimeType;
        }
        MediaType mediaType = this.mimeType;
        if (mediaType == null) {
            mediaType = result.getMediaType().orElse(this.defaultMediaType);
        }
        Charset existingEncoding = result.getMediaType().isPresent() && mediaType.getCharset().isPresent() ? mediaType.getCharset().get() : this.defaultEncoding;
        return mediaType.withCharset(existingEncoding);
    }
}

