/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.management.stats.InputDecoratedCursorStreamProvider;
import org.mule.runtime.core.internal.util.message.ResultToMessageIterator;
import org.mule.runtime.core.internal.util.message.ResultToMessageStreamingIterator;
import org.mule.runtime.core.internal.util.message.ResultsToMessageList;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Message toMessage(Result result) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY));
    }

    public static Message toMessage(Result result, MediaType mediaType) {
        return MessageUtils.toMessage(result, mediaType, null, (BaseEventContext)null, null);
    }

    public static Message toMessage(Result result, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), cursorProviderFactory, eventContext, originatingLocation);
    }

    public static Message toMessage(Result result, CursorProviderFactory cursorProviderFactory, CoreEvent event, ComponentLocation originatingLocation) {
        return MessageUtils.toMessage(result, cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorComponentDecoratorFactory componentDecoratorFactory, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation, String correlationId) {
        Object output = result.getOutput() instanceof InputStream ? componentDecoratorFactory.decorateOutput((InputStream)result.getOutput(), correlationId) : (result.getOutput() instanceof Collection ? componentDecoratorFactory.decorateOutputCollection((Collection)result.getOutput(), correlationId) : (result.getOutput() instanceof Iterator ? componentDecoratorFactory.decorateOutput((Iterator)result.getOutput(), correlationId) : result.getOutput()));
        Object value = StreamingUtils.streamingContent(output, cursorProviderFactory, eventContext, originatingLocation);
        return MessageUtils.toMessage(result, DataType.builder().fromObject(value).mediaType(mediaType).build(), value);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        Object value = StreamingUtils.streamingContent(result.getOutput(), cursorProviderFactory, eventContext, originatingLocation);
        return MessageUtils.toMessage(result, DataType.builder().fromObject(value).mediaType(mediaType).build(), value);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, DataType dataType, ComponentLocation originatingLocation) {
        Object value = StreamingUtils.streamingContent(result.getOutput(), cursorProviderFactory, eventContext, originatingLocation);
        return MessageUtils.toMessage(result, DataType.builder(dataType).mediaType(mediaType).build(), value);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, CoreEvent event, ComponentLocation originatingLocation) {
        return MessageUtils.toMessage(result, mediaType, cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, CoreEvent event, DataType dataType, ComponentLocation originatinLocation) {
        return MessageUtils.toMessage(result, mediaType, cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), dataType, originatinLocation);
    }

    public static List<Message> toMessageCollection(Collection<Result> results, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        if (!(results instanceof List)) {
            results = new ArrayList<Result>(results);
        }
        return new ResultsToMessageList((List)results, cursorProviderFactory, eventContext, originatingLocation);
    }

    public static Iterator<Message> toMessageIterator(Iterator<Result> results, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        if (results instanceof StreamingIterator) {
            return new ResultToMessageStreamingIterator((StreamingIterator)results, cursorProviderFactory, eventContext, originatingLocation);
        }
        return new ResultToMessageIterator(results, cursorProviderFactory, eventContext, originatingLocation);
    }

    private static Message toMessage(Result<?, ?> result, DataType dataType, Object value) {
        Message.Builder builder = Message.builder().payload(new TypedValue<Object>(value, dataType, result.getByteLength()));
        if (result.getAttributes().isPresent()) {
            Object att = result.getAttributes().get();
            Optional<MediaType> attributesMediaType = result.getAttributesMediaType();
            builder.attributes(new TypedValue(att, attributesMediaType.isPresent() ? DataType.builder().type(att.getClass()).mediaType(attributesMediaType.get()).build() : DataType.fromObject(att), OptionalLong.empty()));
        }
        return builder.build();
    }

    public static Object decorateInput(Object v, String eventCorrelationId, CursorComponentDecoratorFactory componentDecoratorFactory) {
        if (v instanceof byte[]) {
            componentDecoratorFactory.computeInputByteCount((byte[])v);
            return v;
        }
        if (v instanceof InputStream) {
            return componentDecoratorFactory.decorateInput((InputStream)v, eventCorrelationId);
        }
        if (v instanceof Collection) {
            return componentDecoratorFactory.decorateInput((Collection)v, eventCorrelationId);
        }
        if (v instanceof Iterator) {
            return componentDecoratorFactory.decorateInput((Iterator)v, eventCorrelationId);
        }
        if (v instanceof CursorStreamProvider) {
            return new InputDecoratedCursorStreamProvider((CursorStreamProvider)v, componentDecoratorFactory, eventCorrelationId);
        }
        return v;
    }
}

