/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.runtime.config.StaticConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;

public final class ConfigurationProviderToolingAdapter
extends StaticConfigurationProvider
implements MetadataKeyProvider,
ConfigurationParameterValueProvider {
    private final MuleMetadataService metadataService;
    protected final ConnectionManager connectionManager;
    private final ConfigurationInstance configuration;
    private final ReflectionCache reflectionCache;

    ConfigurationProviderToolingAdapter(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration, ReflectionCache reflectionCache, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, configuration, muleContext);
        this.configuration = configuration;
        this.reflectionCache = reflectionCache;
        DefaultRegistry registry = new DefaultRegistry(muleContext);
        this.connectionManager = (ConnectionManager)registry.lookupByName("_muleConnectionManager").get();
        this.metadataService = registry.lookupByType(MuleMetadataService.class).get();
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys() {
        MetadataKeysContainerBuilder keysBuilder = MetadataKeysContainerBuilder.getInstance();
        ClassLoader classLoader = MuleExtensionUtils.getClassLoader(this.getExtensionModel());
        return ClassUtils.withContextClassLoader(classLoader, () -> {
            MetadataContext metadataContext = null;
            try {
                metadataContext = this.getMetadataContext(classLoader);
                this.addComponentKeys(this.getConfigurationModel().getOperationModels(), metadataContext, keysBuilder);
                this.addComponentKeys(this.getConfigurationModel().getSourceModels(), metadataContext, keysBuilder);
                MetadataResult<MetadataKeysContainer> metadataResult = MetadataResult.success(keysBuilder.build());
                return metadataResult;
            }
            catch (Exception e) {
                MetadataResult metadataResult = MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
                return metadataResult;
            }
            finally {
                if (metadataContext != null) {
                    metadataContext.dispose();
                }
            }
        });
    }

    private void addComponentKeys(List<? extends ComponentModel> components, MetadataContext metadataContext, MetadataKeysContainerBuilder keysBuilder) throws MetadataResolvingException, ConnectionException {
        for (ComponentModel componentModel : components) {
            TypeKeysResolver keysResolver = MuleExtensionUtils.getMetadataResolverFactory(componentModel).getKeyResolver();
            String categoryName = keysResolver.getCategoryName();
            if ("NullCategory".equals(categoryName) || keysBuilder.containsCategory(categoryName)) continue;
            keysBuilder.add(categoryName, keysResolver.getKeys(metadataContext));
        }
    }

    private MetadataContext getMetadataContext(ClassLoader classLoader) {
        return new DefaultMetadataContext(() -> {
            CoreEvent fakeEvent = null;
            try {
                fakeEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                Optional<ConfigurationInstance> optional = Optional.of(this.get(fakeEvent));
                return optional;
            }
            finally {
                if (fakeEvent != null) {
                    ((BaseEventContext)fakeEvent.getContext()).success();
                }
            }
        }, this.connectionManager, this.metadataService.getMetadataCache(this.getName()), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(classLoader));
    }

    @Override
    public Set<Value> getConfigValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> {
            ConfigurationModel configurationModel = this.getConfigurationModel();
            return new ValueProviderMediator<ConfigurationModel>(configurationModel, () -> this.muleContext, () -> this.reflectionCache).getValues(parameterName, this.getParameterValueResolver(this.configuration.getValue(), configurationModel));
        }, this.getExtensionModel());
    }

    @Override
    public List<ValueProviderModel> getConfigModels(String providerName) throws ValueResolvingException {
        return ValueProviderUtils.getValueProviderModels(this.getConfigurationModel().getAllParameterModels());
    }

    @Override
    public Set<Value> getConnectionValues(String parameterName) throws ValueResolvingException {
        return ValueProviderUtils.valuesWithClassLoader(() -> this.withConnectionProviderInfo((connection, model) -> {
            ValueProviderMediator<ConnectionProviderModel> valueProviderMediator = new ValueProviderMediator<ConnectionProviderModel>(model, () -> this.muleContext, () -> this.reflectionCache);
            return valueProviderMediator.getValues(parameterName, this.getParameterValueResolver(connection, model));
        }), this.getExtensionModel());
    }

    @Override
    public List<ValueProviderModel> getConnectionModels(String providerName) throws ValueResolvingException {
        return this.withConnectionProviderInfo((connection, model) -> ValueProviderUtils.getValueProviderModels(model.getAllParameterModels()));
    }

    private <T> T withConnectionProviderInfo(WithConnectionProviderCallable<T> withConnectionProviderCallable) throws ValueResolvingException {
        ConnectionProvider connectionProvider = this.configuration.getConnectionProvider().orElseThrow(() -> new ValueResolvingException("Unable to obtain the Connection Provider Instance", "UNKNOWN"));
        ConnectionProvider unwrap = ConnectionProviderUtils.unwrapProviderWrapper(connectionProvider);
        ConnectionProviderModel connectionProviderModel = IntrospectionUtils.getConnectionProviderModel(unwrap.getClass(), MuleExtensionUtils.getAllConnectionProviders(this.getExtensionModel(), this.getConfigurationModel())).orElseThrow(() -> new ValueResolvingException("Internal error. Unable to obtain the Connection Provider Model", "UNKNOWN"));
        return withConnectionProviderCallable.call(unwrap, connectionProviderModel);
    }

    private ParameterValueResolver getParameterValueResolver(Object object, ParameterizedModel configurationModel) {
        return new ObjectBasedParameterValueResolver(object, configurationModel, this.reflectionCache);
    }

    @FunctionalInterface
    private static interface WithConnectionProviderCallable<T> {
        public T call(ConnectionProvider var1, ConnectionProviderModel var2) throws ValueResolvingException;
    }
}

