/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.MatcherCollisionException;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.server.DecodingException;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestMatcherRegistry<T>
implements RequestMatcherRegistry<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestMatcherRegistry.class);
    private static final String WILDCARD_CHARACTER = "*";
    private static final String SLASH = "/";
    private static final String ENCODED_SLASH = "%2F";
    public static final String HTTP_SERVICE_ENCODED_SLASH_ENABLED_PROPERTY = "mule.http.service.encoded.slash.enabled";
    private final boolean HTTP_SERVICE_ENCODED_SLASH_ENABLED = Boolean.valueOf(System.getProperty("mule.http.service.encoded.slash.enabled", "false"));
    static final Supplier NULL_SUPPLIER = () -> null;
    private Path serverRequestHandler;
    private final Path rootPath = new Path("root", null);
    private final Path catchAllPath = new Path("*", null);
    private final Set<String> paths = new HashSet<String>();
    private final Supplier<T> noMatchMismatchHandler;
    private final Supplier<T> notFoundMismatchHandler;
    private final Supplier<T> invalidRequestHandler;
    private final Supplier<T> notAvailableMismatchHandler;
    private final LoadingCache<String, List<Path>> requestsPathsCache = Caffeine.newBuilder().maximumSize(32L).build(requestPath -> {
        try {
            String fullPathName = this.pathDecodedWithEncodedSlashes((String)requestPath);
            Preconditions.checkArgument(fullPathName.startsWith(SLASH), "path parameter must start with /");
            Stack<Path> found = this.findPossibleRequestHandlers(fullPathName);
            ArrayList foundAsList = Collections.list(found.elements());
            Collections.reverse(foundAsList);
            return foundAsList;
        }
        catch (DecodingException e) {
            return null;
        }
    });

    private String pathDecodedWithEncodedSlashes(String requestPath) throws DecodingException {
        String fullPathName = HttpParser.decodePath(requestPath);
        if (!this.HTTP_SERVICE_ENCODED_SLASH_ENABLED) {
            return fullPathName;
        }
        int percentages = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Integer pos = -1;
        while ((pos = Integer.valueOf(requestPath.indexOf("%", pos + 1))) != -1) {
            if (requestPath.regionMatches(pos, ENCODED_SLASH, 0, ENCODED_SLASH.length())) {
                positions.add(pos - 2 * percentages);
            }
            ++percentages;
        }
        if (positions.isEmpty()) {
            return fullPathName;
        }
        StringBuilder fullPathNameWithEscapedSlashes = new StringBuilder();
        int lastPosition = 0;
        for (Integer slashPos : positions) {
            fullPathNameWithEscapedSlashes.append(fullPathName.substring(lastPosition, slashPos)).append(ENCODED_SLASH);
            lastPosition = slashPos + 1;
        }
        fullPathNameWithEscapedSlashes.append(fullPathName.substring(lastPosition));
        return fullPathNameWithEscapedSlashes.toString();
    }

    public DefaultRequestMatcherRegistry() {
        this(NULL_SUPPLIER, NULL_SUPPLIER, NULL_SUPPLIER, NULL_SUPPLIER);
    }

    public DefaultRequestMatcherRegistry(Supplier<T> noMatchMismatchHandler, Supplier<T> notFoundMismatchHandler, Supplier<T> invalidRequestHandler, Supplier<T> notAvailableMismatchHandler) {
        this.noMatchMismatchHandler = noMatchMismatchHandler;
        this.notFoundMismatchHandler = notFoundMismatchHandler;
        this.invalidRequestHandler = invalidRequestHandler;
        this.notAvailableMismatchHandler = notAvailableMismatchHandler;
    }

    @Override
    public synchronized RequestMatcherRegistry.RequestMatcherRegistryEntry add(PathAndMethodRequestMatcher requestMatcher, T requestHandler) {
        Path requestHandlerOwner;
        RequestHandlerMatcherPair addedRequestHandlerMatcherPair;
        String requestMatcherPath = HttpParser.normalizePathWithSpacesOrEncodedSpaces(requestMatcher.getPath());
        Preconditions.checkArgument(requestMatcherPath.startsWith(SLASH) || requestMatcherPath.equals(WILDCARD_CHARACTER), "path parameter must start with /");
        this.validateCollision(requestMatcher);
        List<String> matcherMethods = requestMatcher.getMethodRequestMatcher().getMethods();
        this.paths.add(this.getMethodAndPath(Arrays.toString(matcherMethods.toArray()), requestMatcherPath));
        Path currentPath = this.rootPath;
        if (requestMatcherPath.equals(WILDCARD_CHARACTER)) {
            this.serverRequestHandler = new Path("server", null);
            addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
            requestHandlerOwner = this.serverRequestHandler;
            this.serverRequestHandler.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
        } else if (requestMatcherPath.equals("/*")) {
            addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
            requestHandlerOwner = this.catchAllPath;
            this.catchAllPath.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
        } else if (requestMatcherPath.equals(SLASH)) {
            addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
            requestHandlerOwner = this.rootPath;
            this.rootPath.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
        } else {
            String[] pathParts = this.splitPath(requestMatcherPath);
            int insertionLevel = this.getPathPartsSize(requestMatcherPath);
            for (int i = 1; i < insertionLevel - 1; ++i) {
                String currentPathName = pathParts[i];
                Path path = currentPath.getChildPath(currentPathName, null);
                if (i != insertionLevel - 1 && path == null) {
                    path = new Path(currentPathName, path);
                    currentPath.addChildPath(currentPathName, path);
                }
                currentPath = path;
            }
            String currentPathName = pathParts[insertionLevel - 1];
            Path path = currentPath.getLastChildPath(currentPathName);
            if (path == null) {
                path = new Path(currentPathName, path);
                currentPath.addChildPath(currentPathName, path);
            }
            if (requestMatcherPath.endsWith(WILDCARD_CHARACTER)) {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                path.addWildcardRequestHandler(addedRequestHandlerMatcherPair);
                requestHandlerOwner = path;
            } else {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                path.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
                requestHandlerOwner = path;
            }
        }
        this.requestsPathsCache.invalidateAll();
        return new DefaultRequestMatcherRegistryEntry(requestHandlerOwner, addedRequestHandlerMatcherPair);
    }

    private void validateCollision(PathAndMethodRequestMatcher newListenerRequestMatcher) {
        String newListenerRequestMatcherPath = newListenerRequestMatcher.getPath();
        Stack<Path> possibleRequestHandlers = this.findPossibleRequestHandlers(newListenerRequestMatcherPath);
        for (Path possibleRequestHandler : possibleRequestHandlers) {
            List requestHandlerMatcherPairs = possibleRequestHandler.getRequestHandlerMatcherPairs();
            for (RequestHandlerMatcherPair requestHandlerMatcherPair : requestHandlerMatcherPairs) {
                String newListenerRequestMatcherLastPathPart;
                String possibleCollisionLastPathPart;
                PathAndMethodRequestMatcher requestMatcher = requestHandlerMatcherPair.getRequestMatcher();
                String possibleCollisionRequestMatcherPath = requestMatcher.getPath();
                if (!this.isSameDepth(possibleCollisionRequestMatcherPath, newListenerRequestMatcherPath) || !newListenerRequestMatcher.getMethodRequestMatcher().intersectsWith(requestMatcher.getMethodRequestMatcher()) || !((possibleCollisionLastPathPart = this.getLastPathPortion(possibleCollisionRequestMatcherPath)).equals(newListenerRequestMatcherLastPathPart = this.getLastPathPortion(newListenerRequestMatcherPath)) || DefaultRequestMatcherRegistry.isCatchAllPath(possibleCollisionLastPathPart) && DefaultRequestMatcherRegistry.isCatchAllPath(newListenerRequestMatcherLastPathPart) || DefaultRequestMatcherRegistry.isCatchAllPath(possibleCollisionLastPathPart) && DefaultRequestMatcherRegistry.isUriParameter(newListenerRequestMatcherLastPathPart) || DefaultRequestMatcherRegistry.isUriParameter(possibleCollisionLastPathPart) && DefaultRequestMatcherRegistry.isCatchAllPath(newListenerRequestMatcherLastPathPart)) && (!DefaultRequestMatcherRegistry.isUriParameter(possibleCollisionLastPathPart) || !DefaultRequestMatcherRegistry.isUriParameter(newListenerRequestMatcherLastPathPart))) continue;
                throw new MatcherCollisionException(I18nMessageFactory.createStaticMessage(String.format("Already exists a listener matching that path and methods. Listener matching %s new listener %s", requestMatcher, newListenerRequestMatcher)));
            }
        }
    }

    private static boolean isUriParameter(String pathPart) {
        return (pathPart.startsWith("{") || pathPart.startsWith("/{")) && pathPart.endsWith("}");
    }

    private String getLastPathPortion(String possibleCollisionRequestMatcherPath) {
        String[] parts = this.splitPath(possibleCollisionRequestMatcherPath);
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    private boolean isSameDepth(String possibleCollisionRequestMatcherPath, String newListenerRequestMatcherPath) {
        return this.getPathPartsSize(possibleCollisionRequestMatcherPath) == this.getPathPartsSize(newListenerRequestMatcherPath);
    }

    private int getPathPartsSize(String path) {
        int pathSize = this.splitPath(path).length - 1;
        return pathSize += path.endsWith(SLASH) ? 1 : 0;
    }

    private String[] splitPath(String path) {
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        return path.split(SLASH, -1);
    }

    private static boolean isCatchAllPath(String path) {
        return WILDCARD_CHARACTER.equals(path);
    }

    @Override
    public T find(HttpRequest request) {
        List foundPaths = (List)this.requestsPathsCache.get((Object)request.getPath());
        if (foundPaths == null) {
            return this.invalidRequestHandler.get();
        }
        boolean methodNotAllowed = false;
        RequestHandlerMatcherPair<T> requestHandlerMatcherPair = null;
        for (Path path : foundPaths) {
            List requestHandlerMatcherPairs = path.getRequestHandlerMatcherPairs();
            if (requestHandlerMatcherPairs == null && path.getCatchAll() != null) {
                requestHandlerMatcherPairs = path.getCatchAll().requestHandlerMatcherPairs;
            }
            if ((requestHandlerMatcherPair = this.findRequestHandlerMatcherPair(requestHandlerMatcherPairs, request)) != null) break;
            if (requestHandlerMatcherPairs.isEmpty()) continue;
            methodNotAllowed = true;
        }
        if (requestHandlerMatcherPair == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No listener found for request: {}", (Object)this.getMethodAndPath(request.getMethod(), request.getPath()));
                LOGGER.info("Available listeners are: [{}]", (Object)String.join((CharSequence)", ", this.paths));
            }
            if (methodNotAllowed) {
                return this.noMatchMismatchHandler.get();
            }
            return this.notFoundMismatchHandler.get();
        }
        if (!requestHandlerMatcherPair.isRunning()) {
            return this.notAvailableMismatchHandler.get();
        }
        return (T)requestHandlerMatcherPair.getRequestHandler();
    }

    void removeRequestHandler(PathAndMethodRequestMatcher requestMatcher) {
        this.paths.remove(this.getMethodAndPath(requestMatcher));
    }

    private String getMethodAndPath(PathAndMethodRequestMatcher matcher) {
        return this.getMethodAndPath(Arrays.toString(matcher.getMethodRequestMatcher().getMethods().toArray()), matcher.getPath());
    }

    private String getMethodAndPath(String method, String path) {
        return "(" + method + ")" + path;
    }

    private Stack<Path> findPossibleRequestHandlers(String fullPathName) {
        Path currentPath = this.rootPath;
        Path auxPath = null;
        String[] pathParts = this.splitPath(fullPathName);
        Stack<Path> foundPaths = new Stack<Path>();
        foundPaths.add(this.catchAllPath);
        if (fullPathName.equals(WILDCARD_CHARACTER)) {
            foundPaths.push(this.serverRequestHandler);
            return foundPaths;
        }
        if (fullPathName.equals(SLASH)) {
            foundPaths.push(this.rootPath);
            return foundPaths;
        }
        for (int i = 1; i < pathParts.length && currentPath != null; ++i) {
            String currentPathName = pathParts[i];
            Path path = currentPath.getChildPath(currentPathName, i < pathParts.length - 1 ? pathParts[i + 1] : null);
            if (path == null) {
                this.addCatchAllPathIfNotNull(currentPath, foundPaths);
                path = currentPath.getCatchAllUriParam();
            } else if (path.getCatchAll() != null) {
                auxPath = path;
            }
            if (i == pathParts.length - 1 || path == null) {
                if (auxPath != null) {
                    this.addCatchAllPathIfNotNull(auxPath, foundPaths);
                }
                if (path != null) {
                    this.addCatchAllPathIfNotNull(path, foundPaths);
                    foundPaths.push(path);
                } else {
                    this.addCatchAllPathIfNotNull(currentPath, foundPaths);
                }
            }
            currentPath = path;
        }
        return foundPaths;
    }

    private void addCatchAllPathIfNotNull(Path currentPath, Stack<Path> foundPaths) {
        Path catchAllPath = currentPath.getCatchAll();
        if (catchAllPath != null) {
            foundPaths.push(catchAllPath);
        }
    }

    private RequestHandlerMatcherPair<T> findRequestHandlerMatcherPair(List<RequestHandlerMatcherPair<T>> requestHandlerMatcherPairs, HttpRequest request) {
        for (RequestHandlerMatcherPair<T> requestHandlerMatcherPair : requestHandlerMatcherPairs) {
            if (!requestHandlerMatcherPair.getRequestMatcher().matches(request)) continue;
            return requestHandlerMatcherPair;
        }
        return null;
    }

    public class DefaultRequestMatcherRegistryEntry
    implements RequestMatcherRegistry.RequestMatcherRegistryEntry {
        private final Path requestHandlerOwner;
        private final RequestHandlerMatcherPair requestHandlerMatcherPair;

        public DefaultRequestMatcherRegistryEntry(Path requestHandlerOwner, RequestHandlerMatcherPair requestHandlerMatcherPair) {
            this.requestHandlerOwner = requestHandlerOwner;
            this.requestHandlerMatcherPair = requestHandlerMatcherPair;
        }

        @Override
        public void disable() {
            this.requestHandlerMatcherPair.setIsRunning(false);
        }

        @Override
        public void enable() {
            this.requestHandlerMatcherPair.setIsRunning(true);
        }

        @Override
        public void remove() {
            DefaultRequestMatcherRegistry.this.removeRequestHandler(this.requestHandlerMatcherPair.getRequestMatcher());
            this.requestHandlerOwner.removeRequestHandlerMatcherPair(this.requestHandlerMatcherPair);
            DefaultRequestMatcherRegistry.this.requestsPathsCache.invalidateAll();
        }
    }

    public static class RequestHandlerMatcherPair<A> {
        private final PathAndMethodRequestMatcher requestMatcher;
        private final A requestHandler;
        private boolean running = true;

        private RequestHandlerMatcherPair(PathAndMethodRequestMatcher requestMatcher, A requestHandler) {
            this.requestMatcher = requestMatcher;
            this.requestHandler = requestHandler;
        }

        public PathAndMethodRequestMatcher getRequestMatcher() {
            return this.requestMatcher;
        }

        public A getRequestHandler() {
            return this.requestHandler;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setIsRunning(Boolean running) {
            this.running = running;
        }
    }

    public static class Path<H> {
        private final List<RequestHandlerMatcherPair<H>> requestHandlerMatcherPairs = new ArrayList<RequestHandlerMatcherPair<H>>();
        private final String name;
        private final Path parent;
        private final Map<String, Path> subPaths = new HashMap<String, Path>();
        private Path catchAll;
        private Path catchAllUriParam;

        public Path(String name, Path parent) {
            this.name = name;
            this.parent = parent;
        }

        public Path getCatchAll() {
            return this.catchAll;
        }

        public Path getCatchAllUriParam() {
            return this.catchAllUriParam;
        }

        public Path getChildPath(String subPath, String nextSubPath) {
            if (DefaultRequestMatcherRegistry.isCatchAllPath(subPath) || DefaultRequestMatcherRegistry.isUriParameter(subPath) || this.isViablePath(nextSubPath) && !this.matchesNextSubPaths(subPath, nextSubPath)) {
                return this.getCatchAllUriParam();
            }
            Path path = this.subPaths.get(subPath);
            return path;
        }

        private boolean isViablePath(String nextSubPath) {
            if (this.getCatchAllUriParam() != null && nextSubPath != null) {
                return this.getCatchAllUriParam().subPaths.containsKey(nextSubPath);
            }
            return false;
        }

        private boolean matchesNextSubPaths(String subPath, String nextSubPath) {
            Path nextPath;
            if (this.subPaths.containsKey(subPath) && (nextPath = this.subPaths.get(subPath)).getSubPaths() != null) {
                return nextPath.getSubPaths().containsKey(nextSubPath);
            }
            return false;
        }

        public Path getLastChildPath(String subPath) {
            if (DefaultRequestMatcherRegistry.isCatchAllPath(subPath) || DefaultRequestMatcherRegistry.isUriParameter(subPath)) {
                return this.getCatchAllUriParam();
            }
            Path path = this.subPaths.get(subPath);
            return path;
        }

        public void addRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (requestHandlerMatcherPair.getRequestMatcher().getMethodRequestMatcher().acceptsAll()) {
                this.requestHandlerMatcherPairs.add(requestHandlerMatcherPair);
            } else {
                this.requestHandlerMatcherPairs.add(0, requestHandlerMatcherPair);
            }
        }

        public void addChildPath(String pathName, Path path) {
            if (pathName.equals(DefaultRequestMatcherRegistry.WILDCARD_CHARACTER) || pathName.endsWith("}")) {
                this.catchAllUriParam = path;
            } else {
                this.subPaths.put(pathName, path);
            }
        }

        public void removeChildPath(String pathName) {
            this.subPaths.remove(pathName);
            this.removeSelfIfEmpty();
        }

        public boolean isEmpty() {
            return !(!this.requestHandlerMatcherPairs.isEmpty() || !this.subPaths.isEmpty() || this.catchAll != null && !this.catchAll.isEmpty() || this.catchAllUriParam != null && !this.catchAllUriParam.isEmpty());
        }

        public Map<String, Path> getSubPaths() {
            return this.subPaths;
        }

        public List<RequestHandlerMatcherPair<H>> getRequestHandlerMatcherPairs() {
            return this.requestHandlerMatcherPairs;
        }

        public void addWildcardRequestHandler(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.catchAll == null) {
                this.catchAll = new Path<H>(DefaultRequestMatcherRegistry.WILDCARD_CHARACTER, this);
            }
            this.catchAll.addRequestHandlerMatcherPair(requestHandlerMatcherPair);
        }

        public boolean removeRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.requestHandlerMatcherPairs.remove(requestHandlerMatcherPair)) {
                this.removeSelfIfEmpty();
                return true;
            }
            if (this.catchAll != null && this.catchAll.removeRequestHandlerMatcherPair(requestHandlerMatcherPair)) {
                if (this.catchAll.isEmpty()) {
                    this.catchAll = null;
                }
                this.removeSelfIfEmpty();
                return true;
            }
            if (this.catchAllUriParam != null && this.catchAllUriParam.removeRequestHandlerMatcherPair(requestHandlerMatcherPair)) {
                if (this.catchAllUriParam.isEmpty()) {
                    this.catchAllUriParam = null;
                }
                this.removeSelfIfEmpty();
                return true;
            }
            return false;
        }

        private void removeSelfIfEmpty() {
            if (this.isEmpty() && this.parent != null) {
                this.parent.removeChildPath(this.name);
            }
        }
    }
}

