/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.core.api.management.stats.PayloadStatistics;
import org.mule.runtime.core.internal.management.stats.ApplicationStatistics;
import org.mule.runtime.core.internal.management.stats.DefaultFlowsSummaryStatistics;

@NoExtend
public class AllStatistics {
    private boolean isStatisticsEnabled = Boolean.getBoolean("mule.enable.statistics");
    private boolean payloadStatisticsDisabled = Boolean.valueOf(System.getProperty("mule.disable.payload.statistics", "true"));
    private long startTime;
    private final ApplicationStatistics appStats;
    private final FlowsSummaryStatistics flowSummaryStatistics;
    private final Map<String, FlowConstructStatistics> flowConstructStats = new HashMap<String, FlowConstructStatistics>();
    private final Map<String, PayloadStatistics> payloadStatistics = new ConcurrentHashMap<String, PayloadStatistics>();

    public AllStatistics() {
        this.clear();
        this.appStats = new ApplicationStatistics(this);
        this.flowSummaryStatistics = new DefaultFlowsSummaryStatistics(this.isStatisticsEnabled);
        this.appStats.setEnabled(this.isStatisticsEnabled);
        this.add(this.appStats);
    }

    public synchronized void clear() {
        for (FlowConstructStatistics statistics : this.getServiceStatistics()) {
            statistics.clear();
        }
        this.startTime = System.currentTimeMillis();
    }

    public boolean isEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setEnabled(boolean enable) {
        this.isStatisticsEnabled = enable;
        for (FlowConstructStatistics statistics : this.flowConstructStats.values()) {
            statistics.setEnabled(enable);
        }
        if (this.isPayloadStatisticsEnabled()) {
            this.enablePayloadStatistics(enable);
        }
    }

    public void enablePayloadStatistics(boolean b) {
        this.payloadStatisticsDisabled = !b;
        for (PayloadStatistics statistics : this.payloadStatistics.values()) {
            statistics.setEnabled(b);
        }
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void add(FlowConstructStatistics stat) {
        if (stat != null) {
            stat.setEnabled(this.isStatisticsEnabled);
            this.flowConstructStats.put(stat.getName(), stat);
        }
    }

    public synchronized void remove(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.remove(stat.getName());
        }
    }

    public synchronized Collection<FlowConstructStatistics> getServiceStatistics() {
        return this.flowConstructStats.values();
    }

    public FlowConstructStatistics getApplicationStatistics() {
        return this.appStats;
    }

    public FlowsSummaryStatistics getFlowSummaryStatistics() {
        return this.flowSummaryStatistics;
    }

    public Collection<PayloadStatistics> getPayloadStatistics() {
        return this.payloadStatistics.values();
    }

    public PayloadStatistics computePayloadStatisticsIfAbsent(Component component) {
        return this.payloadStatistics.computeIfAbsent(component.getLocation().getLocation(), loc -> {
            PayloadStatistics statistics = new PayloadStatistics((String)loc, component.getIdentifier().toString());
            statistics.setEnabled(this.isPayloadStatisticsEnabled());
            return statistics;
        });
    }

    public PayloadStatistics getPayloadStatistics(String componentLocation) {
        return this.payloadStatistics.get(componentLocation);
    }

    public boolean isPayloadStatisticsEnabled() {
        return this.isEnabled() && !this.payloadStatisticsDisabled;
    }

    public static void configureComputeConnectionErrorsInStats() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.COMPUTE_CONNECTION_ERRORS_IN_STATS, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast("4.4.0")).isPresent());
    }
}

