/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OnCriticalErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private final ErrorTypeMatcher criticalMatcher = new SingleErrorTypeMatcher(DefaultErrorTypeRepository.CRITICAL_ERROR_TYPE);
    private final ErrorTypeMatcher overloadMatcher;

    public OnCriticalErrorHandler(ErrorTypeMatcher overloadMatcher) {
        this.overloadMatcher = overloadMatcher;
    }

    @Override
    public boolean accept(CoreEvent event) {
        Optional<Error> error = event.getError();
        return error.isPresent() && this.criticalMatcher.match(error.get().getErrorType());
    }

    @Override
    public boolean acceptsAll() {
        return false;
    }

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        this.logException(exception);
        return event;
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        this.logException(exception);
        return Mono.error((Throwable)exception);
    }

    public void logException(Throwable exception) {
        ErrorType errorType;
        if (exception instanceof MessagingException && ((MessagingException)exception).getEvent().getError().isPresent() && this.overloadMatcher.match(errorType = ((MessagingException)exception).getEvent().getError().get().getErrorType())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.resolveExceptionAndMessageToLog(exception).toString());
            }
            return;
        }
        this.resolveAndLogException(exception);
    }

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, Consumer<CoreEvent> continueCallback, Consumer<Throwable> propagateCallback) {
        return error -> {
            this.logException((Throwable)error);
            propagateCallback.accept((Throwable)error);
        };
    }

    @Override
    public String toString() {
        return "OnCriticalErrorHandler";
    }
}

