/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    private SingleErrorTypeMatcher redeliveryExhaustedMatcher;

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        ErrorType redeliveryExhaustedErrorType = this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).orElseThrow(() -> new IllegalStateException("REDELIVERY_EXHAUSTED error type not found"));
        this.redeliveryExhaustedMatcher = new SingleErrorTypeMatcher(redeliveryExhaustedErrorType);
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && !this.when.isPresent();
    }

    boolean acceptsErrorType(ErrorType errorType) {
        return this.acceptsAll() || this.errorTypeMatcher != null && this.errorTypeMatcher.match(errorType);
    }

    @Override
    protected Function<CoreEvent, CoreEvent> beforeRouting() {
        return event -> {
            Exception exception = this.getException((CoreEvent)event);
            event = super.beforeRouting().apply((CoreEvent)event);
            if (!this.isRedeliveryExhausted(exception) && this.isOwnedTransaction(exception)) {
                this.rollback(exception);
            }
            return event;
        };
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(ComponentLocation buildFor) {
        OnErrorPropagateHandler cpy = new OnErrorPropagateHandler();
        cpy.setFlowLocation(buildFor);
        this.when.ifPresent(expr -> cpy.setWhen((String)expr));
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setEnableNotifications(this.isEnableNotifications());
        cpy.setLogException(this.logException);
        cpy.setNotificationFirer(this.notificationFirer);
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        if (exception instanceof MessagingException) {
            Optional<Error> error = ((MessagingException)exception).getEvent().getError();
            return error.map(e -> this.redeliveryExhaustedMatcher.match(e.getErrorType())).orElse(false);
        }
        return false;
    }
}

