/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.event.CoreEvent;

public class EventProcessingException
extends MuleException {
    private static final long serialVersionUID = 8849038142532938070L;
    protected final transient CoreEvent event;

    public EventProcessingException(I18nMessage message, CoreEvent event) {
        super(message);
        this.event = event;
        this.storeErrorTypeInfo(event);
    }

    public EventProcessingException(I18nMessage message, CoreEvent event, Throwable cause) {
        super(message, EventProcessingException.getCause(cause));
        this.event = event;
        this.storeErrorTypeInfo(cause);
    }

    public EventProcessingException(CoreEvent event, Throwable cause) {
        this(event, cause, true);
    }

    public EventProcessingException(CoreEvent event, Throwable cause, boolean resolveType) {
        super(resolveType ? EventProcessingException.getCause(cause) : cause);
        this.event = event;
        this.storeErrorTypeInfo(cause);
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    public Component getFailingComponent() {
        return null;
    }

    private static Throwable getCause(Throwable cause) {
        return cause instanceof TypedException ? cause.getCause() : cause;
    }

    protected void storeErrorTypeInfo(Throwable cause) {
        if (cause instanceof TypedException) {
            this.getExceptionInfo().setErrorType(((TypedException)cause).getErrorType());
        } else if (cause instanceof EventProcessingException) {
            this.getExceptionInfo().setErrorType(((EventProcessingException)cause).getExceptionInfo().getErrorType());
        } else {
            this.storeErrorTypeInfo(this.event);
        }
    }

    private void storeErrorTypeInfo(CoreEvent event) {
        event.getError().ifPresent(e -> this.getExceptionInfo().setErrorType(e.getErrorType()));
    }
}

