/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Stack;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.dsl.internal.SourcePosition;
import org.mule.runtime.dsl.internal.xml.parser.DefaultXmlMetadataAnnotations;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotationsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class MuleDocumentLoader {
    private static final UserDataHandler COPY_METADATA_ANNOTATIONS_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 2 || operation == 1) {
                dst.setUserData("metadataAnnotations", src.getUserData("metadataAnnotations"), this);
            }
        }
    };
    private final XmlMetadataAnnotationsFactory metadataFactory = new DefaultXmlMetadataFactory();

    public Document loadDocument(Supplier<SAXParserFactory> saxParserFactorySupplier, InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InputStream inputStream = inputSource.getByteStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
        }
        InputSource defaultInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        InputSource enrichInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        DocumentBuilderFactory factory = this.createDocumentBuilderFactory(validationMode, namespaceAware);
        DocumentBuilder builder = this.createDocumentBuilder(factory, entityResolver, errorHandler);
        Document doc = builder.parse(defaultInputSource);
        this.createSaxAnnotator(saxParserFactorySupplier, doc).parse(enrichInputSource);
        return doc;
    }

    protected XMLReader createSaxAnnotator(Supplier<SAXParserFactory> saxParserFactorySupplier, Document doc) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = saxParserFactorySupplier.get();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader documentReader = saxParser.getXMLReader();
        documentReader.setContentHandler(new XmlMetadataAnnotator(doc, this.metadataFactory));
        return documentReader;
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(int validationMode, boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(this.isValidationEnabled(validationMode));
        if (validationMode == 3) {
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (IllegalArgumentException var6) {
                ParserConfigurationException pcex = new ParserConfigurationException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. Are you running on Java 1.4 with Apache Crimson? Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
                pcex.initCause(var6);
                throw pcex;
            }
        }
        return factory;
    }

    private boolean isValidationEnabled(int validationMode) {
        return validationMode != 0;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory, EntityResolver entityResolver, ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (entityResolver != null) {
            docBuilder.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            docBuilder.setErrorHandler(errorHandler);
        }
        return docBuilder;
    }

    private static final class DomWalkerElement {
        private final DomWalkerElement parent;
        private final Node node;
        private int childIndex = 0;

        public DomWalkerElement(Node node) {
            this.parent = null;
            this.node = node;
        }

        private DomWalkerElement(DomWalkerElement parent, Node node) {
            this.parent = parent;
            this.node = node;
        }

        public DomWalkerElement walkIn() {
            Node nextChild = this.node.getChildNodes().item(this.childIndex++);
            while (nextChild != null && nextChild.getNodeType() != 1) {
                nextChild = this.node.getChildNodes().item(this.childIndex++);
            }
            return new DomWalkerElement(this, nextChild);
        }

        public DomWalkerElement walkOut() {
            Node nextSibling;
            for (nextSibling = this.parent.node.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
            }
            return new DomWalkerElement(this.parent.parent, nextSibling);
        }

        public Node getParentNode() {
            return this.parent.node;
        }
    }

    public static final class XmlMetadataAnnotator
    extends DefaultHandler {
        private Locator locator;
        private DomWalkerElement walker;
        private XmlMetadataAnnotationsFactory metadataFactory;
        private Stack<XmlMetadataAnnotations> annotationsStack = new Stack();
        private SourcePosition trackingPoint = new SourcePosition();

        private XmlMetadataAnnotator(Document doc, XmlMetadataAnnotationsFactory metadataFactory) {
            this.walker = new DomWalkerElement(doc.getDocumentElement());
            this.metadataFactory = metadataFactory;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.walker = this.walker.walkIn();
            XmlMetadataAnnotations metadataBuilder = this.metadataFactory.create(this.locator);
            metadataBuilder.setLineNumber(this.locator.getLineNumber());
            metadataBuilder.setColumnNumber(this.trackingPoint.getColumn() - 1);
            LinkedHashMap<String, String> attsMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                attsMap.put(atts.getQName(i), atts.getValue(i));
            }
            metadataBuilder.appendElementStart(qName, attsMap);
            this.annotationsStack.push(metadataBuilder);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.updateTrackingPoint();
            this.annotationsStack.peek().appendElementBody(new String(ch, start, length).trim());
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.updateTrackingPoint();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SourcePosition tagStartingPosition = this.trackingPoint;
            SourcePosition tagEndPosition = new SourcePosition(this.locator.getLineNumber(), this.locator.getColumnNumber());
            XmlMetadataAnnotations metadataAnnotations = this.annotationsStack.pop();
            metadataAnnotations.appendElementEnd(qName);
            if (!this.annotationsStack.isEmpty()) {
                XmlMetadataAnnotations xmlMetadataAnnotations = this.annotationsStack.peek();
                xmlMetadataAnnotations.appendElementBody(SystemUtils.LINE_SEPARATOR + metadataAnnotations.getElementString() + SystemUtils.LINE_SEPARATOR);
            }
            this.walker.getParentNode().setUserData("metadataAnnotations", metadataAnnotations, COPY_METADATA_ANNOTATIONS_DATA_HANDLER);
            this.walker = this.walker.walkOut();
            this.updateTrackingPoint();
        }

        private void updateTrackingPoint() {
            SourcePosition item = new SourcePosition(this.locator.getLineNumber(), this.locator.getColumnNumber());
            if (this.trackingPoint.compareTo(item) < 0) {
                this.trackingPoint = item;
            }
        }
    }

    private final class DefaultXmlMetadataFactory
    implements XmlMetadataAnnotationsFactory {
        private DefaultXmlMetadataFactory() {
        }

        @Override
        public XmlMetadataAnnotations create(Locator locator) {
            return new DefaultXmlMetadataAnnotations();
        }
    }
}

