/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.connectivity.oauth;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;

public final class AuthorizationCodeGrantType
implements OAuthGrantType {
    public static final String NAME = "Authorization Code";
    private final String accessTokenUrl;
    private final String authorizationUrl;
    private final String accessTokenExpr;
    private final String expirationRegex;
    private final String refreshTokenExpr;
    private final String defaultScope;

    public AuthorizationCodeGrantType(String accessTokenUrl, String authorizationUrl, String accessTokenExpr, String expirationRegex, String refreshTokenExpr, String defaultScope) {
        this.notBlank(accessTokenUrl, "accessTokenUrl");
        this.notBlank(authorizationUrl, "authorizationUrl");
        this.notBlank(accessTokenExpr, "accessTokenExpr");
        this.notBlank(expirationRegex, "expirationRegex");
        this.notBlank(expirationRegex, "expirationRegex");
        this.accessTokenUrl = accessTokenUrl;
        this.authorizationUrl = authorizationUrl;
        this.accessTokenExpr = accessTokenExpr;
        this.expirationRegex = expirationRegex;
        this.refreshTokenExpr = refreshTokenExpr;
        this.defaultScope = StringUtils.isBlank((CharSequence)defaultScope) ? null : defaultScope;
    }

    @Override
    public void accept(OAuthGrantTypeVisitor visitor) {
        visitor.visit(this);
    }

    private void notBlank(String value, String name) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be blank");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public String getAccessTokenExpr() {
        return this.accessTokenExpr;
    }

    @Override
    public String getExpirationRegex() {
        return this.expirationRegex;
    }

    public String getRefreshTokenExpr() {
        return this.refreshTokenExpr;
    }

    public Optional<String> getDefaultScope() {
        return Optional.ofNullable(this.defaultScope);
    }
}

