/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.BackPressureStrategyModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public class BackPressureDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        final ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            @Override
            protected void onSource(SourceDeclaration sourceDeclaration) {
                Optional<ExtensionTypeDescriptorModelProperty> extensionTypeDescriptorModelProperty = sourceDeclaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
                if (extensionTypeDescriptorModelProperty.isPresent()) {
                    Type sourceType = extensionTypeDescriptorModelProperty.get().getType();
                    BackPressureStrategyModelProperty property = sourceType.getAnnotation(BackPressure.class).map(BackPressureStrategyModelProperty::of).orElseGet(BackPressureStrategyModelProperty::getDefault);
                    sourceDeclaration.addModelProperty(property);
                    if (property.getSupportedModes().size() > 1) {
                        BackPressureDeclarationEnricher.this.addBackPressureParameter(extensionDeclaration, sourceDeclaration, property);
                    }
                }
            }
        }.walk(extensionDeclaration);
    }

    private void addBackPressureParameter(ExtensionDeclaration extensionDeclaration, SourceDeclaration sourceDeclaration, BackPressureStrategyModelProperty property) {
        ParameterDeclaration parameter = new ParameterDeclaration("onCapacityOverload");
        parameter.setDescription("Strategy that the runtime will apply when the flow receives more messages than it has the capacity to handle");
        parameter.setRequired(false);
        parameter.setDefaultValue((Object)property.getDefaultMode());
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        DefaultStringType type = BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.format("%s-%s-backPressureStrategy", extensionDeclaration.getName(), sourceDeclaration.getName())).with(new EnumAnnotation(property.getSupportedModes().stream().map(Enum::name).toArray(String[]::new))).build();
        parameter.setType(type, false);
        sourceDeclaration.getParameterGroup("General").addParameter(parameter);
    }
}

