/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.api.metadata.MultilevelMetadataKeyBuilder;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataResolverUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

class MetadataKeysDelegate
extends BaseMetadataDelegate {
    private static final int INITIAL_PART_LEVEL = 1;
    private final List<ParameterModel> keyParts;

    MetadataKeysDelegate(ComponentModel componentModel, List<ParameterModel> metadataKeyParts) {
        super(componentModel);
        this.keyParts = metadataKeyParts;
    }

    MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context, ReflectionCache reflectionCache) {
        return this.getMetadataKeys(context, null, reflectionCache);
    }

    MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context, Object partialKey, ReflectionCache reflectionCache) {
        TypeKeysResolver keyResolver = this.resolverFactory.getKeyResolver();
        String componentResolverName = keyResolver.getCategoryName();
        MetadataKeysContainerBuilder keysContainer = MetadataKeysContainerBuilder.getInstance();
        if (this.keyParts.isEmpty()) {
            return MetadataResult.success(keysContainer.add(componentResolverName, (Set<MetadataKey>)ImmutableSet.of((Object)new NullMetadataKey())).build());
        }
        try {
            Map<Integer, ParameterModel> partsByOrder = this.getPartOrderMapping(this.keyParts);
            Set metadataKeys = MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.getMetadataKeys(context, keyResolver, partialKey, reflectionCache, partsByOrder));
            Set<MetadataKey> enrichedMetadataKeys = metadataKeys.stream().map(metadataKey -> this.cloneAndEnrichMetadataKey((MetadataKey)metadataKey, partsByOrder)).map(MetadataKeyBuilder::build).collect(Collectors.toSet());
            keysContainer.add(componentResolverName, enrichedMetadataKeys);
            return MetadataResult.success(keysContainer.build());
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    private Set<MetadataKey> getMetadataKeys(MetadataContext context, TypeKeysResolver keyResolver, Object partialKey, ReflectionCache reflectionCache, Map<Integer, ParameterModel> partsByOrder) throws Exception {
        if (keyResolver instanceof PartialTypeKeysResolver && this.hasInitialLevel(partialKey, partsByOrder, reflectionCache)) {
            return Collections.singleton(((PartialTypeKeysResolver)keyResolver).resolveChilds(context, partialKey));
        }
        return keyResolver.getKeys(context);
    }

    private boolean hasInitialLevel(Object keyValue, Map<Integer, ParameterModel> partsByOrder, ReflectionCache reflectionCache) {
        if (keyValue == null) {
            return false;
        }
        Optional<DeclaringMemberModelProperty> member = partsByOrder.get(1).getModelProperty(DeclaringMemberModelProperty.class);
        if (!member.isPresent()) {
            return false;
        }
        return IntrospectionUtils.getField(keyValue.getClass(), member.get().getDeclaringField().getName(), reflectionCache).map(field -> {
            field.setAccessible(true);
            try {
                return field.get(keyValue) != null;
            }
            catch (Exception e) {
                return false;
            }
        }).orElse(false);
    }

    private Map<Integer, ParameterModel> getPartOrderMapping(List<ParameterModel> parameterModels) {
        return parameterModels.stream().filter(this::isKeyPart).collect(Collectors.toMap(part -> part.getModelProperty(MetadataKeyPartModelProperty.class).get().getOrder(), part -> part));
    }

    private boolean isKeyPart(ParameterModel part) {
        return part.getModelProperty(MetadataKeyPartModelProperty.class).isPresent();
    }

    private MetadataKeyBuilder cloneAndEnrichMetadataKey(MetadataKey key, Map<Integer, ParameterModel> partOrderMapping) {
        return this.cloneAndEnrichMetadataKey(key, partOrderMapping, 1);
    }

    private MetadataKeyBuilder cloneAndEnrichMetadataKey(MetadataKey key, Map<Integer, ParameterModel> partOrderMapping, int level) {
        MetadataKeyBuilder keyBuilder = MultilevelMetadataKeyBuilder.newKey(key.getId(), partOrderMapping.get(level).getName()).withDisplayName(key.getDisplayName());
        key.getProperties().forEach(keyBuilder::withProperty);
        key.getChilds().forEach(childKey -> keyBuilder.withChild(this.cloneAndEnrichMetadataKey((MetadataKey)childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }
}

