/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public abstract class BaseOAuthConnectionProviderWrapper<C>
extends ReconnectableConnectionProviderWrapper<C>
implements OAuthConnectionProviderWrapper<C> {
    protected final Map<Field, String> callbackValues;

    public BaseOAuthConnectionProviderWrapper(ConnectionProvider<C> delegate, ReconnectionConfig reconnectionConfig, Map<Field, String> callbackValues) {
        super(delegate, reconnectionConfig);
        this.callbackValues = Collections.unmodifiableMap(callbackValues);
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        ConnectionValidationResult connectionValidationResult = ExtensionsOAuthUtils.validateOAuthConnection(this.getDelegate(), connection, this.getContext());
        if (!connectionValidationResult.isValid() && ExtensionsOAuthUtils.refreshTokenIfNecessary(this, (Throwable)connectionValidationResult.getException())) {
            return ExtensionsOAuthUtils.validateOAuthConnection(this.getDelegate(), connection, this.getContext());
        }
        return connectionValidationResult;
    }

    @Override
    public String getResourceOwnerId() {
        return this.getContext().getResourceOwnerId();
    }

    protected abstract ResourceOwnerOAuthContext getContext();
}

