/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\r\u001b\u0001-B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\to\u0001\u0011\t\u0011)A\u0005e!I\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0010\u0005\t}\u0001\u0011\t\u0011)A\u0006\u007f!)Q\t\u0001C\u0001\r\"9A\n\u0001b\u0001\n\u0003i\u0005BB)\u0001A\u0003%a\nC\u0004S\u0001\t\u0007I\u0011A*\t\rm\u0003\u0001\u0015!\u0003U\u0011\u001da\u0006\u00011A\u0005\u0002uCq\u0001\u001a\u0001A\u0002\u0013\u0005Q\r\u0003\u0004l\u0001\u0001\u0006KA\u0018\u0005\bY\u0002\u0001\r\u0011\"\u0001n\u0011\u001d\t\b\u00011A\u0005\u0002IDa\u0001\u001e\u0001!B\u0013q\u0007\"B;\u0001\t\u00031\b\"B=\u0001\t\u0003Q\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001e\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\ti\u0004\u0001C\u0001\u0003\u0013\u0012\u0001#\u00138eKb,GmQ*W!\u0006\u00148/\u001a:\u000b\u0005ma\u0012A\u00029beN,'O\u0003\u0002\u001e=\u00051!/Z1eKJT!a\b\u0011\u0002\u0007\r\u001chO\u0003\u0002\"E\u00051Qn\u001c3vY\u0016T!a\t\u0013\u0002\u0005Y\u0014$BA\u0013'\u0003\u00159X-\u0019<f\u0015\t9\u0003&\u0001\u0003nk2,'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0003CA\u0017/\u001b\u0005Q\u0012BA\u0018\u001b\u0005%\u00195K\u0016)beN,'/\u0001\u0007t_V\u00148-\u001a*fC\u0012,'/F\u00013!\t\u0019T'D\u00015\u0015\ti\u0002%\u0003\u00027i\ta1k\\;sG\u0016\u0014V-\u00193fe\u0006i1o\\;sG\u0016\u0014V-\u00193fe\u0002\n1bY*W'\u0016$H/\u001b8hgB\u0011QFO\u0005\u0003wi\u00111bQ*W'\u0016$H/\u001b8hg&\u0011QHL\u0001\fGN48+\u001a;uS:<7/A\u0002dib\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0012\u0002\u000b5|G-\u001a7\n\u0005\u0011\u000b%!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2a\u0012&L)\tA\u0015\n\u0005\u0002.\u0001!)a(\u0002a\u0002\u007f!)\u0001'\u0002a\u0001e!)\u0001(\u0002a\u0001s\u0005a!/Z2pe\u0012$vn[3ogV\ta\n\u0005\u00024\u001f&\u0011\u0001\u000b\u000e\u0002\u0011\t\u00164\u0017-\u001e7u\u0019>tw-\u0011:sCf\fQB]3d_J$Gk\\6f]N\u0004\u0013AC2tm\u0016sGO]5fgV\tA\u000b\u0005\u0002V36\taK\u0003\u0002\u001e/*\u0011\u0001\fI\u0001\u0004q6d\u0017B\u0001.W\u0005)!vn[3o\u0003J\u0014\u0018-_\u0001\fGN4XI\u001c;sS\u0016\u001c\b%\u0001\u0005m_\u000e\fG/[8o+\u0005q\u0006CA0c\u001b\u0005\u0001'\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004'\u0001\u0002'p]\u001e\fA\u0002\\8dCRLwN\\0%KF$\"AZ5\u0011\u0005};\u0017B\u00015a\u0005\u0011)f.\u001b;\t\u000f)\\\u0011\u0011!a\u0001=\u0006\u0019\u0001\u0010J\u0019\u0002\u00131|7-\u0019;j_:\u0004\u0013a\u00045fC\u0012,'\u000f\u0015:pG\u0016\u001c8/\u001a3\u0016\u00039\u0004\"aX8\n\u0005A\u0004'a\u0002\"p_2,\u0017M\\\u0001\u0014Q\u0016\fG-\u001a:Qe>\u001cWm]:fI~#S-\u001d\u000b\u0003MNDqA\u001b\b\u0002\u0002\u0003\u0007a.\u0001\tiK\u0006$WM\u001d)s_\u000e,7o]3eA\u0005A1m\u001c8uC&t7\u000f\u0006\u0002oo\")\u0001\u0010\u0005a\u0001=\u0006)\u0011N\u001c3fq\u0006\u0019q-\u001a;\u0015\u0005mt\bCA\u0017}\u0013\ti(DA\u0005D'Z\u0013VmY8sI\")\u00010\u0005a\u0001=\u0006A1o[5q\u0019&tW\rF\u0001g\u0003%)G.Z7f]R\fE\u000f\u0006\u0003\u0002\b\u0005-\u0002#B0\u0002\n\u00055\u0011bAA\u0006A\n1q\n\u001d;j_:\u0004b!a\u0004\u0002 \u0005\u0015b\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/Q\u0013A\u0002\u001fs_>$h(C\u0001b\u0013\r\ti\u0002Y\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t#a\t\u0003\u0007M+\u0017OC\u0002\u0002\u001e\u0001\u00042!LA\u0014\u0013\r\tIC\u0007\u0002\u0010\u0013:$W\r_3e\u0007N3VI\u001c;ss\")\u0001p\u0005a\u0001=\u0006I\u0001/\u0019:tK:+\u0007\u0010\u001e\u000b\u0003\u0003\u000f\tQ\u0003\u001d:pG\u0016\u001c8OT8o#V|G/\u001a3F]R\u0014\u0018\u0010\u0006\u0002\u00026A1q,a\u000e\u0002&9L1!!\u000fa\u0005\u0019!V\u000f\u001d7fe\u0005\u0011\u0002O]8dKN\u001c\u0018+^8uK\u0012,e\u000e\u001e:z\u0003-\u0019'/Z1uK\u0016sGO]=\u0015\r\u0005\u0015\u0012\u0011IA#\u0011\u0019\t\u0019e\u0006a\u0001=\u0006Qa/\u00197vK&sG-\u001a=\t\r\u0005\u001ds\u00031\u0001o\u0003!I7/U;pi\u0016$G\u0003CA\u0013\u0003\u0017\ni%!\u0015\t\r\u0005\r\u0003\u00041\u0001_\u0011\u0019\ty\u0005\u0007a\u0001=\u0006!1/\u001b>f\u0011\u0019\t9\u0005\u0007a\u0001]\u0002")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader sourceReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;
    private boolean headerProcessed;

    @Override
    public SourceReader sourceReader() {
        return this.sourceReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean headerProcessed() {
        return this.headerProcessed;
    }

    public void headerProcessed_$eq(boolean x$1) {
        this.headerProcessed = x$1;
    }

    public boolean contains(long index) {
        return this.recordTokens().size() > index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(long index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException(UnknownLocation$.MODULE$, index, this.recordTokens().size());
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.sourceReader()));
    }

    @Override
    public void skipLine() {
        this.sourceReader().seek(this.location());
        char next = this.sourceReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.sourceReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.sourceReader().readAscii();
                next = this.sourceReader().lookAheadAscii();
                this.location_$eq(this.sourceReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(long index) {
        None$ none$;
        long size;
        if (!this.headerProcessed()) {
            Option<Seq<IndexedCSVEntry>> headerParsing;
            boolean hasHeaderLine;
            int headerLine = super.csvSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.csvSettings().header() && (headerParsing = this.parseNext()).isDefined()) {
                this.processHeaders((Seq<? extends CSVEntry>)((Seq)headerParsing.get()));
            }
            this.skipLines(this.linesToSkipBeforeBody());
            this.headerProcessed_$eq(true);
        }
        if ((size = this.recordTokens().size()) <= index) {
            for (long remaining = index - size; remaining >= 0L; --remaining) {
                Option<Seq<IndexedCSVEntry>> nextRecordMaybe = this.parseNext();
                if (!nextRecordMaybe.isDefined()) continue;
                Seq nextRecord = (Seq)nextRecordMaybe.get();
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some((Object)nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply(index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.sourceReader(), this.helper());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    private Option<Seq<IndexedCSVEntry>> parseNext() {
        None$ none$;
        block3: {
            block2: {
                ArrayBuffer recordEntries;
                do {
                    this.sourceReader().seek(this.location());
                    recordEntries = new ArrayBuffer();
                    char value = this.sourceReader().lookAheadAscii();
                    if (value == '\uffff') break block2;
                    boolean recordFinished = false;
                    while (!recordFinished) {
                        Tuple2<IndexedCSVEntry, Object> quotedEntry = this.processNonQuotedEntry();
                        recordEntries.$plus$eq(quotedEntry._1());
                        recordFinished = quotedEntry._2$mcZ$sp();
                    }
                    this.location_$eq(this.sourceReader().position());
                } while (super.csvSettings().ignoreEmptyLine() && recordEntries.length() == 1 && ((IndexedCSVEntry)recordEntries.apply(0)).length() == 0L);
                none$ = new Some((Object)recordEntries);
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processNonQuotedEntry() {
        void var1_1;
        Tuple2 result = null;
        boolean isBlank = true;
        long valueIndex = this.sourceReader().position();
        boolean isQuoted = false;
        while (result == null) {
            Object object;
            char next = this.read();
            if (this.isQuoteChar(next) && isBlank) {
                result = this.processQuotedEntry();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEscapeChar(next) && this.requiresEscape(this.sourceReader().lookAheadAscii())) {
                char c = this.read();
                if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c))) {
                    isBlank = false;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isColumnSeparator(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEndOfInput(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, this.sourceReader().position() - valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isLineEnding(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (next == '\r' && this.sourceReader().lookAheadAscii() == '\n') {
                    object = BoxesRunTime.boxToCharacter((char)this.sourceReader().readAscii());
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(next))) {
                isBlank = false;
            }
            object = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processQuotedEntry() {
        void var3_2;
        long valueIndex = this.sourceReader().position();
        Tuple2 result = null;
        boolean isQuoted = true;
        while (result == null) {
            Character c;
            char next = this.read();
            long size = this.sourceReader().previousPosition() - valueIndex;
            if (this.isEscapeChar(next) && this.requiresEscapeInQuoted(this.sourceReader().lookAheadAscii())) {
                c = BoxesRunTime.boxToCharacter((char)this.read());
                continue;
            }
            if (this.isQuoteChar(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)this.consumeUntilEndOfEntry()));
            } else if (this.isEndOfInput(next)) {
                this.logInvalidEndOfString();
                long newSize = this.sourceReader().position() - valueIndex;
                result = new Tuple2((Object)this.createEntry(valueIndex, newSize < 0L ? 0L : newSize, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            c = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public IndexedCSVEntry createEntry(long valueIndex, boolean isQuoted) {
        return this.createEntry(valueIndex, this.sourceReader().previousPosition() - valueIndex, isQuoted);
    }

    public IndexedCSVEntry createEntry(long valueIndex, long size, boolean isQuoted) {
        long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size, isQuoted);
        return new IndexedCSVEntry(token, this.sourceReader(), this.helper());
    }

    public IndexedCSVParser(SourceReader sourceReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.sourceReader = sourceReader;
        super(cSVSettings, ctx);
        this.recordTokens = ctx.registerCloseable(new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.csvEntries = ctx.registerCloseable(new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.location = 0L;
        this.headerProcessed = false;
    }
}

