/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.core.internal.config.preferred.PreferredObjectSelector;
import org.mule.runtime.core.internal.util.DefaultMethodInvoker;

public class InjectParamsFromContextServiceMethodInvoker
extends DefaultMethodInvoker {
    public static final String MANY_CANDIDATES_ERROR_MSG_TEMPLATE = "More than one invocation candidate for method '%s' in service '%s'";
    public static final String NO_OBJECT_FOUND_FOR_PARAM = "No object found in the registry for parameter '%s' of method '%s' in service '%s'";
    private final LoadingCache<Pair<Object, Method>, Method> injectableMethodCache;
    private final LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache;
    private final LoadingCache<String, Optional<?>> lookupByNameCache;

    public InjectParamsFromContextServiceMethodInvoker(Registry registry) {
        Preconditions.checkArgument(registry != null, "registry cannot be null");
        this.lookupAllByTypeCache = Caffeine.newBuilder().build(registry::lookupAllByType);
        this.lookupByNameCache = Caffeine.newBuilder().build(registry::lookupByName);
        this.injectableMethodCache = Caffeine.newBuilder().build(p -> this.resolveInjectableMethod(p.getFirst(), (Method)p.getSecond()));
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        List<Object> augmentedArgs;
        Method injectable = (Method)this.injectableMethodCache.get(new Pair<Object, Method>(target, method));
        if (injectable == method) {
            return super.invoke(target, method, args);
        }
        try {
            augmentedArgs = this.calculateAugmentedArgs(target, method, args, injectable);
        }
        catch (NullPointerException e) {
            return super.invoke(target, method, args);
        }
        return super.invoke(target, injectable, augmentedArgs.toArray());
    }

    private List<Object> calculateAugmentedArgs(Object target, Method method, Object[] args, Method injectable) {
        ArrayList<Object> augmentedArgs = args == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(args));
        for (int i = method.getParameters().length; i < injectable.getParameters().length; ++i) {
            Object arg;
            Parameter parameter = injectable.getParameters()[i];
            Named named = parameter.getAnnotation(Named.class);
            if (named != null) {
                arg = ((Optional)this.lookupByNameCache.get((Object)parameter.getAnnotation(Named.class).value())).orElseThrow(() -> new IllegalDependencyInjectionException(String.format(NO_OBJECT_FOUND_FOR_PARAM, parameter.getName(), injectable.getName(), target.toString())));
            } else {
                Collection lookupObjects = (Collection)this.lookupAllByTypeCache.get(parameter.getType());
                arg = new PreferredObjectSelector().select(lookupObjects.iterator());
            }
            augmentedArgs.add(arg);
        }
        return augmentedArgs;
    }

    private Method resolveInjectableMethod(Object target, Method method) {
        Method candidate = null;
        for (Method serviceImplMethod : this.getImplementationDeclaredMethods(target)) {
            if (!Modifier.isPublic(serviceImplMethod.getModifiers()) || !serviceImplMethod.getName().equals(method.getName()) || ((Inject[])serviceImplMethod.getAnnotationsByType(Inject.class)).length <= 0 || !this.equivalentParams(method.getParameters(), serviceImplMethod.getParameters())) continue;
            if (!(candidate == null || candidate.getName().equals(serviceImplMethod.getName()) && Arrays.deepEquals(candidate.getParameterTypes(), serviceImplMethod.getParameterTypes()))) {
                throw new IllegalDependencyInjectionException(String.format(MANY_CANDIDATES_ERROR_MSG_TEMPLATE, method.getName(), target.toString()));
            }
            candidate = serviceImplMethod;
        }
        return candidate != null ? candidate : method;
    }

    private Method[] getImplementationDeclaredMethods(Object target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> clazz = target.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private boolean equivalentParams(Parameter[] invocationParams, Parameter[] serviceImplParams) {
        if (serviceImplParams.length < invocationParams.length) {
            return false;
        }
        int i = 0;
        for (Parameter invocationParam : invocationParams) {
            if (!serviceImplParams[i].getType().equals(invocationParam.getType())) {
                return false;
            }
            ++i;
        }
        for (int j = i; j < serviceImplParams.length; ++j) {
            if (serviceImplParams[j].isAnnotationPresent(Named.class) || !((Collection)this.lookupAllByTypeCache.get(serviceImplParams[j].getType())).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

