/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class MuleConfigurationConfigurator
extends AbstractComponentFactory
implements SmartFactoryBean {
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    @Inject
    private ConfigurationProperties configurationProperties;
    private DefaultMuleConfiguration config = new DefaultMuleConfiguration();

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    private void applyDefaultIfNoObjectSerializerSet(DefaultMuleConfiguration configuration) {
        ObjectSerializer configuredSerializer = this.config.getDefaultObjectSerializer();
        if (configuredSerializer != null) {
            configuration.setDefaultObjectSerializer(configuredSerializer);
            if (this.muleContext instanceof DefaultMuleContext) {
                ((DefaultMuleContext)this.muleContext).setObjectSerializer(configuredSerializer);
            }
        }
    }

    public Class<?> getObjectType() {
        return MuleConfiguration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        this.config.setDefaultSynchronousEndpoints(synchronous);
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        this.config.setDefaultResponseTimeout(responseTimeout);
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.config.setDefaultTransactionTimeout(defaultTransactionTimeout);
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.config.setShutdownTimeout(shutdownTimeout);
    }

    public void setDefaultErrorHandlerName(String defaultErrorHandlerName) {
        this.config.setDefaultErrorHandlerName(defaultErrorHandlerName);
    }

    public void setDefaultObjectSerializer(ObjectSerializer objectSerializer) {
        this.config.setDefaultObjectSerializer(objectSerializer);
    }

    public void setMaxQueueTransactionFilesSize(int queueTransactionFilesSizeInMegabytes) {
        this.config.setMaxQueueTransactionFilesSize(queueTransactionFilesSizeInMegabytes);
    }

    public void setDynamicConfigExpiration(DynamicConfigExpiration dynamicConfigExpiration) {
        this.config.setDynamicConfigExpiration(dynamicConfigExpiration);
    }

    public void setInheritIterableRepeatability(String inheritIterableRepeatability) {
        this.config.setInheritIterableRepeatability(inheritIterableRepeatability);
    }

    public void setExtensions(List<ConfigurationExtension> extensions) {
        this.config.addExtensions(extensions);
    }

    public Object doGetObject() throws Exception {
        MuleConfiguration configuration = this.muleContext.getConfiguration();
        if (configuration instanceof DefaultMuleConfiguration) {
            DefaultMuleConfiguration defaultConfig = (DefaultMuleConfiguration)configuration;
            defaultConfig.setLazyInit(LifecycleUtils.isLazyInitMode(this.configurationProperties));
            defaultConfig.setDefaultResponseTimeout(this.config.getDefaultResponseTimeout());
            defaultConfig.setDefaultTransactionTimeout(this.config.getDefaultTransactionTimeout());
            defaultConfig.setShutdownTimeout(this.config.getShutdownTimeout());
            defaultConfig.setDefaultErrorHandlerName(this.config.getDefaultErrorHandlerName());
            defaultConfig.addExtensions(this.config.getExtensions());
            defaultConfig.setMaxQueueTransactionFilesSize(this.config.getMaxQueueTransactionFilesSizeInMegabytes());
            defaultConfig.setDynamicConfigExpiration(this.config.getDynamicConfigExpiration());
            defaultConfig.setInheritIterableRepeatability(this.config.isInheritIterableRepeatability());
            this.applyDefaultIfNoObjectSerializerSet(defaultConfig);
            return configuration;
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage("Unable to set properties on read-only MuleConfiguration: " + configuration.getClass()));
    }
}

