/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class TrackingPostProcessor
implements BeanPostProcessor {
    private List<String> trackingList = new ArrayList<String>();
    private boolean tracking = false;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.tracking) {
            StringUtils.ifNotBlank(beanName, value -> {
                if (!this.trackingList.contains(value)) {
                    this.trackingList.add((String)value);
                }
            });
        }
        return bean;
    }

    public List<String> getBeansTracked() {
        return ImmutableList.copyOf(this.trackingList);
    }

    public void startTracking() {
        this.tracking = true;
    }

    public void stopTracking() {
        this.tracking = false;
    }

    public void intersection(Collection<String> beanNames) {
        this.trackingList.removeIf(name -> !beanNames.contains(name));
    }

    public void reset() {
        this.trackingList.clear();
    }
}

