/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.internal.model.DefaultComponentParameterAst;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;

public class SpringComponentModel
extends ComponentModel
implements ComponentAst {
    private final Map<String, ComponentParameterAst> parameterAsts = new HashMap<String, ComponentParameterAst>();
    private String componentId;
    private final AtomicBoolean parameterAstsPopulated = new AtomicBoolean(false);
    private BeanReference beanReference;
    private BeanDefinition beanDefinition;

    public void setBeanDefinition(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public void setBeanReference(BeanReference beanReference) {
        this.beanReference = beanReference;
    }

    public BeanReference getBeanReference() {
        return this.beanReference;
    }

    @Override
    public ComponentLocation getLocation() {
        return this.getComponentLocation();
    }

    @Override
    public Optional<String> getComponentId() {
        if (this.getType() != null && MuleConfiguration.class.isAssignableFrom(this.getType())) {
            return Optional.of("_muleConfiguration");
        }
        if (this.getModel(ConstructModel.class).map(cm -> cm.getName().equals("object")).orElse(false).booleanValue()) {
            return Optional.ofNullable(this.getRawParameters().get("name"));
        }
        if (this.getModel(ParameterizedModel.class).isPresent()) {
            this.populateParameterAsts();
            return Optional.ofNullable(this.componentId);
        }
        return Optional.ofNullable(this.getRawParameters().get("name"));
    }

    @Override
    public Optional<String> getRawParameterValue(String paramName) {
        if (paramName.equals("$%body%$")) {
            return Optional.ofNullable(this.getTextContent());
        }
        return Optional.ofNullable(this.getRawParameters().get(paramName));
    }

    @Override
    public void setParameter(ParameterModel parameterModel, ComponentParameterAst value) {
        this.parameterAstsPopulated.set(false);
        super.setParameter(parameterModel, value);
        this.parameterAsts.put(parameterModel.getName(), value);
    }

    @Override
    public ComponentParameterAst getParameter(String paramName) {
        this.populateParameterAsts();
        return this.parameterAsts.get(paramName);
    }

    @Override
    public Collection<ComponentParameterAst> getParameters() {
        this.populateParameterAsts();
        return this.parameterAsts.values().stream().filter(param -> param.getValue().getValue().isPresent()).collect(Collectors.toSet());
    }

    private void populateParameterAsts() {
        if (!this.parameterAstsPopulated.compareAndSet(false, true)) {
            return;
        }
        if (!this.getModel(ParameterizedModel.class).isPresent()) {
            throw new IllegalStateException("Model for '" + this.toString() + "' (a '" + this.getModel(NamedObject.class).map(NamedObject::getName) + ")' is not parameterizable.");
        }
        this.getModel(ParameterizedModel.class).ifPresent(parameterizedModel -> parameterizedModel.getAllParameterModels().forEach(paramModel -> {
            ComponentParameterAst computedParam = this.parameterAsts.computeIfAbsent(paramModel.getName(), paramNameKey -> this.findParameterModel((String)paramNameKey).map(foundParamModel -> this.getRawParameterValue((String)paramNameKey).map(rawParamValue -> new DefaultComponentParameterAst((String)rawParamValue, () -> foundParamModel)).orElseGet(() -> new DefaultComponentParameterAst(null, () -> foundParamModel))).orElseThrow(() -> {
                String msgPrefix = String.format("Wanted paramName '%s' from object '%s'.", paramNameKey, this.getModel(NamedObject.class).map(n -> n.getName()).orElse("(null)"));
                if (!this.getModel(ParameterizedModel.class).isPresent()) {
                    return new NoSuchElementException(msgPrefix + " The model is not parameterizable.");
                }
                List availableParams = this.getModel(ParameterizedModel.class).get().getAllParameterModels().stream().map(pm -> pm.getName()).collect(Collectors.toList());
                return new NoSuchElementException(msgPrefix + " Available: " + availableParams);
            }));
            if (paramModel.isComponentId()) {
                this.componentId = (String)computedParam.getValue().getRight();
            }
        }));
    }

    private Optional<ParameterModel> findParameterModel(String paramName) {
        Optional<ParameterModel> parameterModel = this.getModel(SourceModel.class).flatMap(sourceModel -> {
            Optional<ParameterModel> findFirst;
            if (sourceModel.getErrorCallback().isPresent() && (findFirst = sourceModel.getErrorCallback().get().getAllParameterModels().stream().filter(pm -> pm.getName().equals(paramName)).findFirst()).isPresent()) {
                return findFirst;
            }
            if (sourceModel.getSuccessCallback().isPresent()) {
                return sourceModel.getSuccessCallback().get().getAllParameterModels().stream().filter(pm -> pm.getName().equals(paramName)).findFirst();
            }
            return Optional.empty();
        });
        if (!parameterModel.isPresent()) {
            parameterModel = this.getModel(ParameterizedModel.class).flatMap(parameterizedModel -> parameterizedModel.getAllParameterModels().stream().filter(pm -> pm.getName().equals(paramName)).findFirst());
        }
        return parameterModel;
    }

    @Override
    public Stream<ComponentAst> recursiveStream() {
        return StreamSupport.stream(this.recursiveSpliterator(), false);
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator() {
        return new Spliterator<ComponentAst>(){
            private boolean rootProcessed = false;
            private Spliterator<ComponentAst> currentChildSpliterator;
            private Spliterator<ComponentAst> innerSpliterator;

            @Override
            public boolean tryAdvance(Consumer<? super ComponentAst> action) {
                if (!this.rootProcessed) {
                    this.rootProcessed = true;
                    action.accept(SpringComponentModel.this);
                    return true;
                }
                this.trySplit();
                if (this.currentChildSpliterator != null) {
                    if (this.currentChildSpliterator.tryAdvance(action)) {
                        return true;
                    }
                    this.currentChildSpliterator = null;
                    return this.tryAdvance(action);
                }
                if (this.innerSpliterator.tryAdvance((? super T cm) -> {
                    this.currentChildSpliterator = cm.recursiveSpliterator();
                })) {
                    return this.tryAdvance(action);
                }
                return false;
            }

            @Override
            public Spliterator<ComponentAst> trySplit() {
                if (this.innerSpliterator == null) {
                    this.innerSpliterator = SpringComponentModel.this.directChildrenStream().spliterator();
                }
                return null;
            }

            @Override
            public long estimateSize() {
                return 1L + SpringComponentModel.this.directChildrenStream().mapToLong(inner -> inner.recursiveSpliterator().estimateSize()).sum();
            }

            @Override
            public int characteristics() {
                return 17745;
            }
        };
    }

    @Override
    public Stream<ComponentAst> directChildrenStream() {
        return this.getInnerComponents().stream().map(cm -> (ComponentAst)((Object)cm));
    }

    @Override
    public Spliterator<ComponentAst> directChildrenSpliterator() {
        return this.directChildrenStream().spliterator();
    }

    public String toString() {
        return this.getComponentId().map(n -> "" + n + "(" + this.getIdentifier().toString() + ")").orElse(this.getIdentifier().toString()) + (this.getLocation() != null ? " @ " + this.getLocation().getLocation() : "");
    }
}

