/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;

public class MacroExpansionModuleModel {
    public static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    public static final String MODULE_CONNECTION_GLOBAL_ELEMENT_NAME = "connection";
    public static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    public static final QName ORIGINAL_IDENTIFIER = new QName("http://www.mulesoft.org/schema/mule/parser-metadata", "ORIGINAL_IDENTIFIER");
    public static final String TNS_PREFIX = "tns";
    private static final String DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX = "%s-default-config-global-element-suffix";
    private final ApplicationModel applicationModel;
    private final ExtensionModel extensionModel;

    MacroExpansionModuleModel(ApplicationModel applicationModel, ExtensionModel extensionModel) {
        this.applicationModel = applicationModel;
        this.extensionModel = extensionModel;
    }

    public void expand() {
        List<ComponentModel> moduleGlobalElements = this.getModuleGlobalElements();
        Set<String> moduleGlobalElementsNames = moduleGlobalElements.stream().map(ComponentModel::getNameAttribute).collect(Collectors.toSet());
        this.expandOperations(moduleGlobalElementsNames);
        this.expandGlobalElements(moduleGlobalElements, moduleGlobalElementsNames);
    }

    private void expandOperations(Set<String> moduleGlobalElementsNames) {
        this.applicationModel.executeOnEveryMuleComponentTree(containerComponentModel -> containerComponentModel.getInnerComponents().stream().filter(operationRefModel -> operationRefModel.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix())).forEach(operationRefModel -> operationRefModel.getModel(OperationModel.class).ifPresent(operationModel -> {
            String containerName = this.calculateContainerRootName((ComponentModel)containerComponentModel, (OperationModel)operationModel);
            ComponentModel moduleOperationChain = this.createModuleOperationChain((ComponentModel)operationRefModel, (OperationModel)operationModel, moduleGlobalElementsNames, Optional.empty(), containerName);
            moduleOperationChain.getInnerComponents().forEach(inner -> inner.setParent((ComponentModel)operationRefModel));
            operationRefModel.getInnerComponents().addAll(moduleOperationChain.getInnerComponents());
        })));
    }

    private String calculateContainerRootName(ComponentModel containerComponentModel, OperationModel operationModel) {
        String nameAttribute;
        if (containerComponentModel.isRoot()) {
            nameAttribute = containerComponentModel.getNameAttribute();
        } else if (containerComponentModel.getParent() != null) {
            nameAttribute = this.calculateContainerRootName(containerComponentModel.getParent(), operationModel);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Should have not reach here. There was no root container element while doing the macro expansion for the module [%s], operation [%s]", this.extensionModel.getName(), operationModel.getName())));
        }
        return nameAttribute;
    }

    private Optional<String> defaultGlobalElementName() {
        Optional<String> defaultElementName = Optional.empty();
        if (this.extensionModel.getConfigurationModels().isEmpty() && this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            defaultElementName = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(globalElementComponentModelModelProperty -> String.format(DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX, this.extensionModel.getName()));
        }
        return defaultElementName;
    }

    private void expandGlobalElements(List<ComponentModel> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        if (this.defaultGlobalElementName().isPresent()) {
            this.addDefaultGlobalElements(moduleGlobalElementsNames);
        } else {
            this.macroExpandGlobalElements(moduleComponentModels, moduleGlobalElementsNames);
        }
    }

    private void addDefaultGlobalElements(Set<String> moduleGlobalElementsNames) {
        String defaultGlobalElementSuffix = this.defaultGlobalElementName().get();
        ComponentModel rootComponentModel = this.applicationModel.getRootComponentModel();
        List<ComponentModel> globalElements = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).get().getGlobalElements();
        globalElements.forEach(globalElementComponenModel -> {
            ComponentModel macroExpandedImplicitGlobalElement = this.copyGlobalElementComponentModel((ComponentModel)globalElementComponenModel, defaultGlobalElementSuffix, moduleGlobalElementsNames, (Map<String, String>)new HashMap<String, String>());
            macroExpandedImplicitGlobalElement.setRoot(true);
            macroExpandedImplicitGlobalElement.setParent(rootComponentModel);
            rootComponentModel.getInnerComponents().add(macroExpandedImplicitGlobalElement);
        });
    }

    private void macroExpandGlobalElements(List<ComponentModel> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        this.applicationModel.executeOnEveryMuleComponentTree(muleRootComponentModel -> {
            for (ComponentModel configRefModel : muleRootComponentModel.getInnerComponents()) {
                if (!configRefModel.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix())) continue;
                ((ComponentAst)((Object)configRefModel)).getModel(ConfigurationModel.class).ifPresent(configurationModel -> {
                    Map<String, String> propertiesMap = ((ComponentAst)((Object)configRefModel)).getParameters().stream().filter(paramAst -> paramAst.getRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getRawValue()));
                    Map<String, String> connectionPropertiesMap = this.extractConnectionProperties((ComponentAst)((Object)configRefModel), (ConfigurationModel)configurationModel);
                    propertiesMap.putAll(connectionPropertiesMap);
                    Map<String, String> literalsParameters = this.getLiteralParameters(propertiesMap, Collections.emptyMap());
                    List<ComponentModel> replacementGlobalElements = this.createGlobalElementsInstance(configRefModel, moduleComponentModels, moduleGlobalElementsNames, literalsParameters);
                    configRefModel.getInnerComponents().clear();
                    configRefModel.getInnerComponents().addAll(replacementGlobalElements);
                });
            }
        });
    }

    private Optional<ConfigurationModel> getConfigurationModel() {
        return this.extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME);
    }

    private List<ComponentModel> createGlobalElementsInstance(ComponentModel configRefModel, List<ComponentModel> moduleGlobalElements, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ComponentModel muleRootElement = configRefModel.getParent();
        return moduleGlobalElements.stream().map(globalElementModel -> {
            ComponentModel macroExpandedGlobalElement = this.copyGlobalElementComponentModel((ComponentModel)globalElementModel, configRefModel.getNameAttribute(), moduleGlobalElementsNames, literalsParameters);
            macroExpandedGlobalElement.setRoot(true);
            macroExpandedGlobalElement.setParent(muleRootElement);
            return macroExpandedGlobalElement;
        }).collect(Collectors.toList());
    }

    private List<ComponentModel> getModuleGlobalElements() {
        return this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(GlobalElementComponentModelModelProperty::getGlobalElements).orElse(new ArrayList());
    }

    private ComponentModel createModuleOperationChain(ComponentModel operationRefModel, OperationModel operationModel, Set<String> moduleGlobalElementsNames, Optional<String> configRefParentTnsName, String containerName) {
        OperationComponentModelModelProperty operationComponentModelModelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class).get();
        ComponentModel operationModuleComponentModel = operationComponentModelModelProperty.getBodyComponentModel();
        List<ComponentModel> bodyProcessors = operationModuleComponentModel.getInnerComponents();
        Optional<String> configRefName = this.referencesOperationsWithinModule((ComponentAst)((Object)operationRefModel)) ? configRefParentTnsName : this.getConfigRefName(operationRefModel);
        ComponentModel.Builder processorChainBuilder = new ComponentModel.Builder();
        processorChainBuilder.setIdentifier(operationRefModel.getIdentifier());
        Map<String, String> propertiesMap = this.extractProperties(configRefName);
        Map<String, String> parametersMap = ((ComponentAst)((Object)operationRefModel)).getParameters().stream().filter(paramAst -> paramAst.getRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getRawValue()));
        operationRefModel.getRawParameters().forEach((paramName, paramValue) -> processorChainBuilder.addParameter((String)paramName, (String)paramValue, operationRefModel.isParameterValueProvidedBySchema((String)paramName)));
        for (ComponentModel componentModel : operationRefModel.getInnerComponents()) {
            ComponentModel copiedParam = new ComponentModel.Builder(componentModel).build();
            processorChainBuilder.addChildComponentModel(copiedParam);
        }
        operationRefModel.getMetadata().getSourceCode().ifPresent(processorChainBuilder::setSourceCode);
        bodyProcessors.stream().map(bodyProcessor -> this.lookForTNSOperation((ComponentAst)((Object)bodyProcessor)).map(tnsOperation -> this.createModuleOperationChain((ComponentModel)bodyProcessor, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRefName, containerName)).orElseGet(() -> this.copyOperationComponentModel((ComponentModel)bodyProcessor, configRefName, moduleGlobalElementsNames, this.getLiteralParameters(propertiesMap, parametersMap), containerName))).forEach(processorChainBuilder::addChildComponentModel);
        this.copyErrorMappings(operationRefModel, processorChainBuilder);
        for (Map.Entry entry : operationRefModel.getMetadata().getParserAttributes().entrySet()) {
            processorChainBuilder.addCustomAttribute((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : operationRefModel.getMetadata().getDocAttributes().entrySet()) {
            processorChainBuilder.addCustomAttribute((String)entry.getKey(), entry.getValue());
        }
        processorChainBuilder.addCustomAttribute(AbstractComponent.ROOT_CONTAINER_NAME_KEY, (Object)containerName);
        operationRefModel.getMetadata().getFileName().ifPresent(processorChainBuilder::setConfigFileName);
        operationRefModel.getMetadata().getStartLine().ifPresent(processorChainBuilder::setLineNumber);
        operationRefModel.getMetadata().getStartColumn().ifPresent(processorChainBuilder::setStartColumn);
        processorChainBuilder.addCustomAttribute(ORIGINAL_IDENTIFIER, (Object)operationRefModel.getIdentifier());
        ComponentModel processorChainModel = processorChainBuilder.build();
        for (ComponentModel processorChainModelChild : processorChainModel.getInnerComponents()) {
            processorChainModelChild.setParent(processorChainModel);
        }
        processorChainModel.setComponentModel(operationModel);
        processorChainModel.setComponentType(operationRefModel.getComponentType());
        return processorChainModel;
    }

    private Optional<String> getConfigRefName(ComponentModel operationRefModel) {
        return operationRefModel.getRawParameters().containsKey(MODULE_OPERATION_CONFIG_REF) ? Optional.of(operationRefModel.getRawParameters().get(MODULE_OPERATION_CONFIG_REF)) : this.defaultGlobalElementName();
    }

    private void copyErrorMappings(ComponentModel operationRefModel, ComponentModel.Builder processorChainBuilder) {
        operationRefModel.getInnerComponents().stream().filter(componentModel -> componentModel.getIdentifier().equals(ApplicationModel.ERROR_MAPPING_IDENTIFIER)).forEach(errorMappingComponentModel -> processorChainBuilder.addChildComponentModel(this.copyComponentModel((ComponentModel)errorMappingComponentModel)));
    }

    private ComponentModel copyComponentModel(ComponentModel modelToCopy) {
        ComponentModel.Builder operationReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getRawParameters().entrySet()) {
            operationReplacementModel.addParameter(entry.getKey(), entry.getValue(), false);
        }
        for (ComponentModel operationChildModel : modelToCopy.getInnerComponents()) {
            operationReplacementModel.addChildComponentModel(this.copyComponentModel(operationChildModel));
        }
        return this.buildFrom(modelToCopy, operationReplacementModel);
    }

    private Map<String, String> getLiteralParameters(Map<String, String> propertiesMap, Map<String, String> parametersMap) {
        Map<String, String> literalsParameters = propertiesMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue));
        literalsParameters.putAll(parametersMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue)));
        return literalsParameters;
    }

    private String getReplaceableExpression(String name, String prefix) {
        return "#[" + prefix + "." + name + "]";
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private Map<String, String> extractProperties(Optional<String> configRefName) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        configRefName.filter(configParameter -> this.defaultGlobalElementName().map(defaultGlobalElementName -> !defaultGlobalElementName.equals(configParameter)).orElse(true)).ifPresent(configParameter -> {
            ComponentAst configRefComponentModel = this.applicationModel.recursiveStream().filter(componentModel -> componentModel.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix())).filter(componentModel -> componentModel.getModel(ConfigurationModel.class).isPresent() && configParameter.equals(componentModel.getComponentId().orElse(null))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app", this.extensionModel.getXmlDslModel().getPrefix(), configParameter)));
            ConfigurationModel configurationModel = this.getConfigurationModel().get();
            configRefComponentModel.getParameters().stream().filter(paramAst -> paramAst.getRawValue() != null).forEach(paramAst -> valuesMap.put(paramAst.getModel().getName(), paramAst.getRawValue()));
            valuesMap.putAll(this.extractConnectionProperties(configRefComponentModel, configurationModel));
        });
        return valuesMap;
    }

    private Map<String, String> extractConnectionProperties(ComponentAst configRefComponentModel, ConfigurationModel configurationModel) {
        return configurationModel.getConnectionProviderModel(MODULE_CONNECTION_GLOBAL_ELEMENT_NAME).flatMap(connectionProviderModel -> configRefComponentModel.directChildrenStream().filter(componentModel -> MODULE_CONNECTION_GLOBAL_ELEMENT_NAME.equals(componentModel.getIdentifier().getName())).findFirst().map(connectionComponentModel -> connectionComponentModel.getParameters().stream().filter(paramAst -> paramAst.getRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getRawValue())))).orElse(Collections.emptyMap());
    }

    private ComponentModel copyGlobalElementComponentModel(ComponentModel modelToCopy, String configRefName, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ComponentModel.Builder globalElementReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getRawParameters().entrySet()) {
            String value = this.calculateAttributeValue(configRefName, moduleGlobalElementsNames, entry.getValue());
            String optimizedValue = literalsParameters.getOrDefault(value, value);
            globalElementReplacementModel.addParameter(entry.getKey(), optimizedValue, false);
        }
        for (ComponentModel operationChildModel : modelToCopy.getInnerComponents()) {
            globalElementReplacementModel.addChildComponentModel(this.copyGlobalElementComponentModel(operationChildModel, configRefName, moduleGlobalElementsNames, literalsParameters));
        }
        return this.buildFrom(modelToCopy, globalElementReplacementModel);
    }

    private ComponentModel copyOperationComponentModel(ComponentModel modelToCopy, Optional<String> configRefName, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters, String containerName) {
        ComponentModel.Builder operationReplacementModel = this.getComponentModelBuilderFrom(modelToCopy);
        for (Map.Entry<String, String> entry : modelToCopy.getRawParameters().entrySet()) {
            String value = configRefName.map(s -> this.calculateAttributeValue((String)s, moduleGlobalElementsNames, (String)entry.getValue())).orElseGet(entry::getValue);
            String optimizedValue = literalsParameters.getOrDefault(value, value);
            operationReplacementModel.addParameter(entry.getKey(), optimizedValue, false);
        }
        modelToCopy.getInnerComponents().stream().map(operationChildModel -> this.lookForTNSOperation((ComponentAst)((Object)operationChildModel)).map(tnsOperation -> this.createModuleOperationChain((ComponentModel)operationChildModel, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRefName, containerName)).orElseGet(() -> this.copyOperationComponentModel((ComponentModel)operationChildModel, configRefName, moduleGlobalElementsNames, literalsParameters, containerName))).forEach(operationReplacementModel::addChildComponentModel);
        return this.buildFrom(modelToCopy, operationReplacementModel);
    }

    private ComponentModel.Builder getComponentModelBuilderFrom(ComponentModel componentModelOrigin) {
        ComponentModel.Builder operationReplacementModel = new ComponentModel.Builder();
        operationReplacementModel.setIdentifier(componentModelOrigin.getIdentifier()).setTextContent(componentModelOrigin.getTextContent());
        for (Map.Entry<String, Object> entry : componentModelOrigin.getMetadata().getParserAttributes().entrySet()) {
            operationReplacementModel.addCustomAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : componentModelOrigin.getMetadata().getDocAttributes().entrySet()) {
            operationReplacementModel.addCustomAttribute(entry.getKey(), entry.getValue());
        }
        return operationReplacementModel;
    }

    private ComponentModel buildFrom(ComponentModel componentModelOrigin, ComponentModel.Builder operationReplacementModel) {
        componentModelOrigin.getMetadata().getFileName().ifPresent(operationReplacementModel::setConfigFileName);
        componentModelOrigin.getMetadata().getStartLine().ifPresent(operationReplacementModel::setLineNumber);
        componentModelOrigin.getMetadata().getStartColumn().ifPresent(operationReplacementModel::setStartColumn);
        componentModelOrigin.getMetadata().getSourceCode().ifPresent(operationReplacementModel::setSourceCode);
        ComponentModel componentModel = operationReplacementModel.build();
        for (ComponentModel child : componentModel.getInnerComponents()) {
            child.setParent(componentModel);
        }
        return componentModel;
    }

    private boolean referencesOperationsWithinModule(ComponentAst operationComponentModel) {
        return TNS_PREFIX.equals(operationComponentModel.getIdentifier().getNamespace());
    }

    private Optional<OperationModel> lookForTNSOperation(ComponentAst componentModel) {
        if (this.referencesOperationsWithinModule(componentModel)) {
            return componentModel.getModel(OperationModel.class);
        }
        return Optional.empty();
    }

    private String calculateAttributeValue(String configRefNameToAppend, Set<String> moduleGlobalElementsNames, String originalValue) {
        String result = moduleGlobalElementsNames.contains(originalValue) ? originalValue.concat("-").concat(configRefNameToAppend) : originalValue;
        return result;
    }
}

